<?php
date_default_timezone_set("America/Santiago");


if(strlen($_GET['desde'])>0 and strlen($_GET['hasta'])>0){
	$desde = $_GET['desde'];
	$hasta = $_GET['hasta'];

	$verDesde = date('d/m/Y', strtotime($desde));
	$verHasta = date('d/m/Y', strtotime($hasta));
}else{
	$desde = '1111-01-01';
	$hasta = '9999-12-30';

	$verDesde = '__/__/____';
	$verHasta = '__/__/____';
}
require('../fpdf/fpdf.php');
include('../include/header.php');
$con = opendblocal();

$pdf = new FPDF('L','mm','A4');
$pdf->AddPage();
$pdf->SetFont('Arial', '', 10);
$pdf->Image('../images/membrete.png' , 10 ,8, 50 , 13,'png');
$pdf->ln(15);
$pdf->Cell(90,5,"RUT: 76.317.144-2",0,1,'L');
$pdf->Cell(90,5,"Giro: Desarrollo de Software ",0,1,'L');
$pdf->Ln(1);
$pdf->Cell(90,5,"Web: www.business-intelligent.cl",0,1,'L');
$pdf->Ln(1);
$pdf->Cell(90,5,"Servicio Clientes: (+562) 2.223.96.62",0,1,'L');
$pdf->ln(1);
$pdf->Cell(90,5,utf8_decode("Dirección: San Antonio 486, Santiago, Santiago Centro."),0,1,'L');
$pdf->Cell(90, 5, 'Fecha: '.date('d-m-Y').'  /  Hora: '.date('G:i:s'), 0,1);
$pdf->SetFont('Arial', 'B', 9);
$pdf->Ln(10);
$pdf->Cell(100, 2, 'LISTADO DE BOLETAS', 0,0,'1');
$pdf->SetFont('Arial', '', 9);
$pdf->Cell(50, 5, 'Desde: '.$verDesde.' hasta: '.$verHasta, 0,0);
$pdf->Ln(10);
//==============================================================================
$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(20, 8, 'Item', 1);
$pdf->Cell(25, 8, 'Fecha', 1);
$pdf->Cell(25, 8, 'Hora', 1);
$pdf->Cell(25, 8, 'Boleta', 1);
$pdf->Cell(35, 8, 'Cliente', 1);
$pdf->Cell(25, 8, 'Medio De Pago', 1);
$pdf->Cell(25, 8, 'Monto Total', 1);

$pdf->Ln(8);
$pdf->SetFont('Arial', '', 8);
//CONSULTA
$boletas = mysqli_query($con,"SELECT A.*,C.condicion, DATE_FORMAT( A.fecha, '%d/%m/%Y') AS 'FechaVenta', hora as HoraVenta, B.razon_social,sum(D.precio) as total FROM boletas_pos A LEFT JOIN clientes B ON A.cliente_id=B.ID
												JOIN condicion_pago C ON A.forma_pago = C.id JOIN boleta_det_pos D on A.boleta = D.boleta_id
												WHERE A.fecha BETWEEN '$desde' AND '$hasta' GROUP BY A.boleta;");
$item = 0;
$totaluni = 0;
$totaldis = 0;
while($productos2 = mysqli_fetch_array($boletas)){
	$item = $item+1;
	if($productos2["cliente_id"]==0){
		$productos2["cliente_id"]= "PUBLICO GENERAL";
														
	}
	
	$pdf->Cell(20, 8, $item, 1);
	$pdf->Cell(25, 8,$productos2['FechaVenta'], 1);
	$pdf->Cell(25, 8, $productos2['HoraVenta'], 1);
	$pdf->Cell(25, 8, $productos2['boleta'], 1);

	$pdf->Cell(35, 8, $productos2["cliente_id"], 1);
		$pdf->Cell(25, 8, $productos2['condicion'], 1);
	$pdf->Cell(25, 8, $productos2['total'], 1);
	$total+=$productos2['total'];

	$pdf->Ln(8);
}
// $pdf->SetFont('Arial', 'B', 8);
// $pdf->Cell(125,8,'',0,0);
// $pdf->Cell(40,8,'Total Unitario: $. '.$totaluni,1,0);
// $pdf->Cell(30,8,'Total Dist: $. '.$totaldis,1,0);
$pdf->Ln(12);
$pdf->SetFont('Arial','B',7);
$pdf->Cell(30,10,'Monto Total:',1,0,'0');
$pdf->SetFont('Arial','',7);
$pdf->Cell(30,10,"$".number_format($total,0,",","."),1,0,'c');

$pdf->Output();
?>