<?php
require('fpdf/fpdf.php');
require_once("include/header.php");


class PDF_MC_Table extends FPDF
{
var $widths;
var $aligns;

function SetWidths($w)
{
    //Set the array of column widths
    $this->widths=$w;
}

function SetAligns($a)
{
    //Set the array of column alignments
    $this->aligns=$a;
}

function Row($data)
{
    //Calculate the height of the row
    $nb=0;
    for($i=0;$i<count($data);$i++)
        $nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
    $h=5*$nb;
    //Issue a page break first if needed
    $this->CheckPageBreak($h);
    //Draw the cells of the row
    for($i=0;$i<count($data);$i++)
    {
        $w=$this->widths[$i];
        $a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'L';
        //Save the current position
        $x=$this->GetX();
        $y=$this->GetY();
        //Draw the border
        //$this->Rect($x,$y,$w,$h);
        //Print the text
        $this->MultiCell($w,5,$data[$i],0,$a);
        //Put the position to the right of the cell
        $this->SetXY($x+$w,$y);
    }
    //Go to the next line
    $this->Ln($h);
}

function Row1($data)
{
    //Calculate the height of the row
    $nb=0;
    for($i=0;$i<count($data);$i++)
        $nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
    $h=5*$nb;
    //Issue a page break first if needed
    $this->CheckPageBreak($h);
    //Draw the cells of the row
    for($i=0;$i<count($data);$i++)
    {
        $w=$this->widths[$i];
        $a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'C';
        //Save the current position
        $x=$this->GetX();
        $y=$this->GetY();
        //Draw the border
        $this->Rect($x,$y,$w,$h);
        //Print the text
        $this->MultiCell($w,5,$data[$i],0,$a);
        //Put the position to the right of the cell
        $this->SetXY($x+$w,$y);
    }
	
	
    //Go to the next line
    $this->Ln($h);
	/*if($i > 4 ){
			$this->AddPage();
	}*/
}

function CheckPageBreak($h)
{
    //If the height h would cause an overflow, add a new page immediately
    if($this->GetY()+$h>$this->PageBreakTrigger)
        $this->AddPage($this->CurOrientation);
}

function NbLines($w,$txt)
{
    //Computes the number of lines a MultiCell of width w will take
    $cw=&$this->CurrentFont['cw'];
    if($w==0)
        $w=$this->w-$this->rMargin-$this->x;
    $wmax=($w-2*$this->cMargin)*1000/$this->FontSize;
    $s=str_replace("\r",'',$txt);
    $nb=strlen($s);
    if($nb>0 and $s[$nb-1]=="\n")
        $nb--;
    $sep=-1;
    $i=0;
    $j=0;
    $l=0;
    $nl=1;
    while($i<$nb)
    {
        $c=$s[$i];
        if($c=="\n")
        {
            $i++;
            $sep=-1;
            $j=$i;
            $l=0;
            $nl++;
            continue;
        }
        if($c==' ')
            $sep=$i;
        $l+=$cw[$c];
        if($l>$wmax)
        {
            if($sep==-1)
            {
                if($i==$j)
                    $i++;
            }
            else
                $i=$sep+1;
            $sep=-1;
            $j=$i;
            $l=0;
            $nl++;
        }
        else
            $i++;
    }
    return $nl;
}

function Header()
{
    // Logo
    //$this->Image('images/logo5.png',10,6,30);

	$this->Image($GLOBALS['logo_empresa'],90,5,15,0,'');
    // Arial bold 15
    //$this->SetFont('Arial','B',15);
    // Move to the right
    //$this->Cell(80);
    // Title
   // $this->Cell(30,10,'Title',1,0,'C');
    // Line break
    $this->Ln(10);
	
	$this->SetFont('Arial','B',9);
$this->SetTextColor(234, 8, 8);
//$this->Image('images/logo/imagen_group.jpg',85,5,30,0,'');
//$this->Image('images/cotizacion_detalles_pago.jpg',150,43,50,0,'');
//$this->Ln(10);
$this->SetFont('Arial','',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(30,7,utf8_decode('SEÑOR(ES):'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(80,7,utf8_decode($GLOBALS['señor']),0,0,'c');
$this->SetX(140);

//Numero Documento
$this->SetTextColor(234, 7, 8);
$this->SetFont('Arial','',12);
$this->Cell(60,7,"R.U.T: ".$GLOBALS['rut_empresa'],'RLT',1,'C');

$this->SetFont('Arial','',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(30,7,'R.U.T:',0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(80,7,utf8_decode($GLOBALS['rut_empresa']),0,0,'c');
$this->SetX(140);

//Numero Documento
$this->SetTextColor(234, 8, 8);
$this->SetFont('Arial','',12);
$this->Cell(60,7,utf8_decode('COTIZACION'),'RL',1,'C');

$this->SetFont('Arial','',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(30,7,'GIRO:',0,0,'0');

$this->Cell(80,7,utf8_decode($GLOBALS['giro_empresa']),0,0,'c');
$this->SetX(140);

//Numero Documento
$this->SetTextColor(234, 8, 8);
$this->SetFont('Arial','',12);
$this->Cell(60,7,utf8_decode("N°  ").right("00000".trim($GLOBALS['nroBoleta']),10)."",'RLB',1,'C');

$this->SetFont('Arial','',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(30,7,'DIRECCION:',0,0,'0');

$this->Cell(80,7,utf8_decode($GLOBALS['direccion_empresa']),0,0,'c');
$this->SetX(140);

//Numero Documento
$this->SetTextColor(234, 8, 8);
$this->SetFont('Arial','',12);
$this->Cell(30,7,'','',1,'C');

$this->SetFont('Arial','',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(30,7,utf8_decode('COMUNA:'),0,0,'c');

$this->Cell(80,7,utf8_decode($GLOBALS['comuna_empresa']),0,0,'c');
$this->SetX(380);

//Numero Documento
$this->SetTextColor(234, 8, 8);
$this->SetFont('Arial','',12);
$this->Cell(200,7,'','RLB',1,'C');




$this->SetFont('Arial','',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(30,7,'CONTACTO:',0,0,'0');

$this->Cell(80,7,utf8_decode($GLOBALS['contacto_empresa']),0,1,'c');

$this->Ln(1);
$this->SetFont('Arial','',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(30,7,utf8_decode('TELÉFONO:'),0,0,'0');

$this->Cell(80,7,utf8_decode($GLOBALS['telefono_empresa']),0,1,'c');
$this->Ln(2);
$this->SetFont('Arial','',7);
$this->SetTextColor(0, 0, 0);
$this->SetX(60);

$this->Cell(30,8,utf8_decode('SANTIAGO:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(12,8,$GLOBALS['dia'],'B',0,'C');
$this->SetX(110);
$this->SetTextColor(0, 0, 0);
$this->Cell(15,8,utf8_decode('DE'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(40,8,$GLOBALS['var'],'B',0,'C');
$this->SetX(170);
$this->SetTextColor(0, 0, 0);
$this->Cell(10,8,utf8_decode('DE'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(15,8,$GLOBALS['anio'],'B',0,'c');


$this->Ln(10);
$this->SetFont('Arial','',7);
$this->SetTextColor(0, 0, 0);
$this->Cell(25,8,utf8_decode('SEÑOR(ES):'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(95,8,utf8_decode($GLOBALS['rsocialcliente']),'B',0,'c');
$this->SetX(140);
$this->SetTextColor(0, 0, 0);
$this->Cell(20,8,utf8_decode('R.U.T:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(35,8,utf8_decode($GLOBALS['rcliente']),'B',0,'c');

$this->Ln(8);
$this->SetFont('Arial','',7);
$this->SetTextColor(0, 0, 0);
$this->Cell(25,8,utf8_decode('Dirección:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(95,8,utf8_decode($GLOBALS['direccioncliente']),'B',0,'c');
$this->SetX(140);
$this->SetTextColor(0, 0, 0);
$this->Cell(20,8,utf8_decode('Comuna:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(35,8,utf8_decode($GLOBALS['comunacliente']),'B',0,'c');

$this->Ln(8);
$this->SetFont('Arial','',7);
$this->SetTextColor(0, 0, 0);
$this->Cell(25,8,utf8_decode('Giro:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(95,8,utf8_decode($GLOBALS['girocliente']),'B',0,'c');
$this->SetX(140);
$this->SetTextColor(0, 0, 0);
$this->Cell(20,8,utf8_decode('Fono:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(35,8,utf8_decode($GLOBALS['fonocliente']),'B',0,'c');

$this->Ln(15);


$this->Line(10,$this->GetY(),150,$this->GetY());
$this->SetFont('Arial','B',9);
$this->Cell(30,6,utf8_decode('Fecha Cotización:'),0,0,'0');
$this->SetFont('Arial','',9);
$this->Cell(50,6,$GLOBALS['fechaBoleta'],0,1,'c');

$this->SetFont('Arial','B',9);
$this->Cell(30,6,'Usuario:',0,0,'0');
$this->SetFont('Arial','',9);
$this->Cell(50,6,utf8_decode($GLOBALS['usuario']),0,1,'c');
}

// Page footer
function Footer()
{
    // Position at 1.5 cm from bottom
    
    // Arial italic 8
	$this->SetY(-60);
    $this->SetFont('Arial','B',8);
    // Page number
	$this->SetX(10);
	$this->Cell(30,6,'OBS',1,0,'1');
	$this->Cell(70,6,'DATOS PARA TRANSFERENCIA BANCARIA',1,0,'1');
	$this->SetX(130);
	$this->Cell(30,6,'SUBTOTAL','B',0,'1');
	$this->SetFont('Arial','',8);
	$this->Cell(30,6,number_format($GLOBALS['netot'], 0, ",", "."),'B',0,'R');
	$this->SetFont('Arial','',8);
	$this->Ln(6);
	$this->Cell(30,6,'NOMBRE',1,0,'1');
	$this->Cell(70,6,utf8_decode($GLOBALS['nombre_empresa_t']),1,0,'1');
	$this->SetX(130);
	$this->Cell(30,6,'DESCUENTO','T',0,'1');
	$this->SetFont('Arial','',8);
	$this->Cell(30,6,'','T',0,'R');
	$this->Ln(6);
	$this->Cell(30,6,'RUT',1,0,'1');
	$this->Cell(70,6,utf8_decode($GLOBALS['rut_empresa_t']),1,0,'1');
	$this->SetX(130);
	$this->Cell(30,6,'PRECIO NETO','',0,'1');
	$this->SetFont('Arial','',8);
	$this->Cell(30,6,number_format($GLOBALS['netot'], 0, ",", "."),'',0,'R');
	$this->Ln(6);
	$this->Cell(30,6,'BANCO/ CTA',1,0,'1');
	$this->Cell(70,6,utf8_decode($GLOBALS['cuenta_empresa_t']),1,0,'1');
	$this->SetX(130);
	$this->Cell(30,6,'IVA','',0,'1');
	$this->SetFont('Arial','',8);
	$this->Cell(30,6,number_format($GLOBALS['ivat'], 0, ",", "."),'',0,'R');
	$this->Ln(6);
	$this->Cell(30,6,'CORREO',1,0,'1');
	$this->Cell(70,6,utf8_decode($GLOBALS['correo_empresa_t']),1,0,'1');
	$this->SetX(130);
	$this->Cell(30,6,'PRECIO FINAL','',0,'1');
	$this->SetFont('Arial','',8);
	$this->Cell(30,6,number_format($GLOBALS['montot'], 0, ",", "."),'',0,'R');
	$this->Ln(6);
	$this->Cell(30,6,'FONO',1,0,'1');
	$this->Cell(70,6,utf8_decode($GLOBALS['telefono_empresa_t']),1,0,'1');
	/*$this->SetX(130);
	$this->Cell(30,6,'OBSERVACIONES',1,0,'1');
	$this->SetFont('Arial','',8);
	$this->Cell(30,6,$GLOBALS['med_pago'],1,0,'R');
	$this->Ln(6);
	$this->SetX(130);
	$this->Cell(30,6,'MEDIO DE PAGO',1,0,'1');
	$this->SetFont('Arial','',8);
	$this->Cell(30,6,$GLOBALS['observaciones'],1,0,'R');*/
	$this->SetY(-15);
	$this->SetFont('Arial','I',8);
    $this->Cell(0,10,utf8_decode('Página ').$this->PageNo().'/{nb}',0,0,'R');
	//$this->Image('images/cotizacion_foot.jpg',10,275,190,20,'');
	//$this->Image('images/cotizacion_detalles_pago.jpg',150,240,50,0,'');
}
}
?>