<?php
session_start();
include "../include/header.php";
$con = opendblocal();

date_default_timezone_set('America/Santiago');
$fecha = date('Y-m-d');    
$hora = date('H:i:s');       
$fecha_actual = date('Y-m-d H:i:s'); 

$data = json_decode(file_get_contents("php://input"), true);

if (!isset($data['productos']) || !is_array($data['productos'])) {
    http_response_code(400);
    echo json_encode(["error" => "No se recibieron productos"]);
    exit;
}

foreach ($data['productos'] as $producto) {  
    // Escapar y preparar datos
    $codigo_interno = mysqli_real_escape_string($con, $producto['codigo_interno']);
    $codigo_externo = mysqli_real_escape_string($con, $producto['codigo_externo']);
    $especificaciones = mysqli_real_escape_string($con, $producto['especificaciones']);
    $ubicacion = mysqli_real_escape_string($con, $producto['ubicacion']);
    $subcategoria = mysqli_real_escape_string($con, $producto['subcategoria']);
    $estado = mysqli_real_escape_string($con, $producto['estado']);
    $fecha_compra = mysqli_real_escape_string($con, $producto['fecha_compra']);
    $vida_util = mysqli_real_escape_string($con, $producto['vida_util']);
    $grupo = mysqli_real_escape_string($con, $producto['grupo']);
    $decreto = mysqli_real_escape_string($con, $producto['decreto']);
    $factura = mysqli_real_escape_string($con, $producto['factura']);
    $fecha_factura = mysqli_real_escape_string($con, $producto['fecha_factura']);
    $tipo_documento = mysqli_real_escape_string($con, $producto['tipo_documento']);
    $orden = mysqli_real_escape_string($con, $producto['orden']);
    $fecha_orden = mysqli_real_escape_string($con, $producto['fecha_orden']);
    $rut_proveedor = mysqli_real_escape_string($con, $producto['rut_proveedor']);
    $proveedor = mysqli_real_escape_string($con, $producto['proveedor']);
    $financiamiento = mysqli_real_escape_string($con, $producto['financiamiento']);
    $propiedad = mysqli_real_escape_string($con, $producto['propiedad']);
    $precio_compra = mysqli_real_escape_string($con, $producto['precio_compra']);
    $precio = mysqli_real_escape_string($con, $producto['precio']);
    $dimensiones = mysqli_real_escape_string($con, $producto['dimensiones']);
    $color = mysqli_real_escape_string($con, $producto['color']);
    $n_serie = mysqli_real_escape_string($con, $producto['n_serie']);
    $fecha_garantia = mysqli_real_escape_string($con, $producto['fecha_garantia']);
    $frecuencia_mant = mysqli_real_escape_string($con, $producto['frecuencia_mant']);
    $periodo_mant = mysqli_real_escape_string($con, $producto['periodo_mant']);
    $componetizado = mysqli_real_escape_string($con, $producto['componetizado']);
    $componetizado_principal = mysqli_real_escape_string($con, $producto['componetizado_principal']);
    $nombre_componente = mysqli_real_escape_string($con, $producto['nombre_componente']);
    $inventario = mysqli_real_escape_string($con, $producto['inventario']);
    $descripcion = mysqli_real_escape_string($con, $producto['descripcion']);
    $rut_resp = mysqli_real_escape_string($con, $producto['rut_resp']);
    $nombre_resp = mysqli_real_escape_string($con, $producto['nombre_resp']);
    $cuenta_resp = mysqli_real_escape_string($con, $producto['cuenta_resp']);
    $cargo_resp = mysqli_real_escape_string($con, $producto['cargo_resp']);
    $depreciable = mysqli_real_escape_string($con, $producto['depreciable']);
    $marcas = mysqli_real_escape_string($con, $producto['marcas']);
    $modelos = mysqli_real_escape_string($con, $producto['modelos']);
    //$alta = mysqli_real_escape_string($con, $producto['alta']);

    // buscar id
    $especificaciones_id = buscarId($con, 'modelos', $especificaciones);
    $ubicacion_id = buscarId($con, 'ubicacion', $ubicacion);
    $subcategoria_id = buscarId($con, 'marcas', $subcategoria);
    $estado_id = buscarId($con, 'estado_prod', $estado);

    //obtener principal
    $categoria_id = 0; 
    $query_categoria = "SELECT categoria_id FROM marcas WHERE id = '$subcategoria_id'";
    $result_categoria = mysqli_query($con, $query_categoria);
    if ($row = mysqli_fetch_array($result_categoria)) {
        $categoria_id = $row['categoria_id'];
    }
    mysqli_free_result($result_categoria);


    //Obtener correlativo
    $query_correlativo = "SELECT MAX(correlativo) AS max_correl FROM productos";
    $result_correlativo = mysqli_query($con, $query_correlativo);
    $correlativo_ = 1;
    if ($row = mysqli_fetch_array($result_correlativo)) {
        $correlativo_ = $row['max_correl'] + 1;
    }
    mysqli_free_result($result_correlativo);

    if (productoExiste($con, $codigo_externo)) {
        // Actualizar producto existente
        $query = "UPDATE productos SET 
            codigo_proveedor = '$codigo_interno',
            especificaciones = '$especificaciones',
            ubicacion = '$ubicacion_id',
            categoria_id = '$categoria_id',
            marca_id = '$subcategoria_id',
            modelo_id = '$especificaciones_id',
            estado_prod = '$estado_id',
            fecha_compra = '$fecha_compra',
            vida_util = '$vida_util',
            descripcion_p = '$grupo',
            decreto = '$decreto',
            num_factura = '$factura',
            fecha_factura = '$fecha_factura',
            tipo_documento = '$tipo_documento',
            num_oc = '$orden',
            fecha_orden = '$fecha_orden',
            rut_proveedor = '$rut_proveedor',
            nombre_proveedor = '$proveedor',
            financiamiento = '$financiamiento',
            propiedad = '$propiedad',
            p_compra = '$precio_compra',
            pmp = '$precio',
            dimensiones = '$dimensiones',
            color = '$color',
            num_serie = '$n_serie',
            fecha_garantia_b = '$fecha_garantia',
            frecuencia_mantenimiento = '$frecuencia_mant',
            periodo_mantenimiento = '$periodo_mant',
            componetizado = '$componetizado',
            componente_principal = '$componetizado_principal',
            nombre_componente = '$nombre_componente',
            inventario_componente = '$inventario',
            contenido = '$descripcion',
            rut_responsable = '$rut_resp',
            nombre_responsable = '$nombre_resp',
            cuenta_responsable_habilitada = '$cuenta_resp',
            cargo_responsable = '$cargo_resp',
            depreciable = '$depreciable',
            marcas = '$marcas',
            modelos = '$modelos'
            WHERE codigo_externo = '$codigo_externo'";
    } else {
        $query = "INSERT INTO productos (
                codigo_proveedor, codigo_externo, especificaciones, ubicacion, categoria_id,
                marca_id, modelo_id, estado_prod, correlativo, cantidad_mayor, fecha, hora, fecha_actual, usuario,
                fecha_compra, vida_util, descripcion_p, decreto, num_factura, fecha_factura, tipo_documento, num_oc, fecha_orden,
                rut_proveedor, nombre_proveedor, financiamiento, propiedad, p_compra, pmp, dimensiones, color, num_serie,
                fecha_garantia_b, frecuencia_mantenimiento, periodo_mantenimiento, componetizado, componente_principal, nombre_componente,
                inventario_componente, contenido, rut_responsable, nombre_responsable, cuenta_responsable_habilitada, cargo_responsable, depreciable, estado_bien, marcas, modelos) 
                VALUES ('$codigo_interno', '$codigo_externo', '$especificaciones', '$ubicacion_id', '$categoria_id',
                '$subcategoria_id', '$especificaciones_id', '$estado_id', '$correlativo_', 1000, '$fecha', '$hora', '$fecha_actual', ".$_SESSION['idUsuario'].",
                '$fecha_compra', '$vida_util', '$grupo', '$decreto', '$factura', '$fecha_factura', '$tipo_documento', '$orden', '$fecha_orden',
                '$rut_proveedor', '$proveedor', '$financiamiento', '$propiedad', '$precio_compra', '$precio', '$dimensiones', '$color', '$n_serie',
                '$fecha_garantia', '$frecuencia_mant', '$periodo_mant', '$componetizado', '$componetizado_principal', '$nombre_componente',
                '$inventario', '$descripcion', '$rut_resp', '$nombre_resp', '$cuenta_resp', '$cargo_resp', '$depreciable', '1', '$marcas','$modelos')";
    }

    

    $resultado = mysqli_query($con, $query);
    if (!$resultado) {
        http_response_code(500);
        echo json_encode(["error" => "Error en productos: " . mysqli_error($con)]);
        exit;
    }
}

echo json_encode(["mensaje" => ".$query."]);

function buscarId($con, $tabla, $descripcion) {
    $descripcion = mysqli_real_escape_string($con, $descripcion);
    $query = "SELECT id FROM $tabla WHERE descripcion = '$descripcion' LIMIT 1";
    $result = mysqli_query($con, $query);
    if ($row = mysqli_fetch_array($result)) {
        return $row['id'];
    }
    return null;
}

function productoExiste($con, $codigo_externo) {
    $codigo_externo = mysqli_real_escape_string($con, $codigo_externo);
    $query = "SELECT id FROM productos WHERE codigo_externo = '$codigo_externo' LIMIT 1";
    $result = mysqli_query($con, $query);
    return mysqli_num_rows($result) > 0;
}



?>
