<?php
/**
 *
 *
 * SDKFactronica - Kit de Integracin para Facturacin Electrnica
 * Versin SII Chile 7.2.7. - 20170805
 * @package SDKFactronica
 * @link https://github.com/FacTronica/ The SDKFactronica GitHub project
 * @author Patricio Daz Ziga (Fundador) <webmaster@factronica.cl>
 * @copyright 2017 - 2013 Patricio Daz Ziga
 * @license SDKFactronica 
 * @note Este programa se distribuye bajo licencia de uso SDKFactronica
 * 
 * 
 *  
 */
  
########################################
# INCLUSION  DE FUNCIONES  
########################################
#
include("config.php");
include("obtener_digestion.php");
########################################
# INCLUSION DE CLASES REQUERIDAS
########################################
#
# clase nusoap wsdl
include("class.nusoap.php");
# class FacTronicaLoginSii{
# incluir la clase login sii 
include("class.factronica.loginsii.php");
#######################################################################################
#  RECIBIR ARCHIVO TXT Y LEER SUS DATOS
#######################################################################################
if(isset($_FILES['archivotxt']['tmp_name'])){
	$FACTRONICA["BUZONSERVIDOR"]="temp";
	$nombre_archivo="consultadte_".date("Ymd",time())."_".date("His",time())."_".rand(100,700).".php";
	move_uploaded_file($_FILES['archivotxt']['tmp_name'],$FACTRONICA["BUZONSERVIDOR"].'/'.$nombre_archivo)or die("ERROR: Al guardar Txt");
	# LEER DATOS DEL ARCHIVO TXT RECIBIDO 
	include($FACTRONICA["BUZONSERVIDOR"]."/".$nombre_archivo);  	
}else{
	# LEER DATOS DEL ARCHIVO TXT ESTATICO (TESTING)
	//echo "<br>Leyendo Archivo TXT de Ejemplo...<br>";
	//include("ejemplos/datos_rcv.php");
	include("txt/archivo_plano.php");
}
########################################
# LOGEAR EN EL SII
########################################
#
# INSTANCIAR LA CLASE FacTronicaLoginSii
$objeto = new FacTronicaLoginSii(); 

$intentos_semilla=3;
for($i_semilla=1;$i_semilla<=$intentos_semilla;$i_semilla++){
    //echo "<br>SOLICITANDO SEMILLA $i_semilla";
    if($FACTRONICA["SEMILLA"]>0){
    
    }else{
        # LLAMADA AL METODO ObtenerSemilla
        $objeto->ObtenerSemilla();
        //echo "<br>ObtenerSemilla=".$FACTRONICA["SEMILLA"];
    }   
} 
if($FACTRONICA["SEMILLA"]>0){
    //echo "<BR>SEMILLA OK";
}else{
    //echo "<br>NO HUBO SEMILLA";
    echo "ERROR NO HUBO SEMILLA";
    return;
}
//
$intentos_token=3;
for($i_token=1;$i_token<=$intentos_token;$i_token++){
    //echo "<br>SOLICITANDO TOKEN INTENTO $i_token";
    if(strlen($FACTRONICA["TOKEN"])=="13"){
    
    }else{
        # LLAMADA AL METODO ObtenerToken
        $objeto->ObtenerToken();
        //echo "<br>Token=".$FACTRONICA["TOKEN"];
    }
}
if(strlen($FACTRONICA["TOKEN"])=="13"){
    //echo "<BR>TOKEN OK";
}else{
    //echo "<br>NO HUBO TOKEN";
    echo "ERROR AL LOGEAR EN SII";
    return;
}
#
$token=$FACTRONICA["TOKEN"];
# 
$operacion='COMPRA';
$estadoContab='REGISTRO';
$ptributario=$FACTRONICA["PeriodoTributario"]; 
$empresa=$FACTRONICA["rutEmisor"]."-".$FACTRONICA["dvEmisor"];
$append_url=$FACTRONICA["Origen"];
$pRutEmpresa=$FACTRONICA["rutEmisor"]; 
$pDigEmpresa=$FACTRONICA["dvEmisor"];  
#
$url = "https://www4.sii.cl/consdcvinternetui/services/data/facadeService/$append_url";
$agent = "Mozilla/5.0 (compatible; PROG 1.0; Windows NT 5.0; YComp 5.0.2.4)";
//   
$header =  array(
"Accept: application/json, text/plain, */*",
"Accept-Encoding: gzip, deflate, br",
"Content-Type: application/json",
"Accept-Language: es-ES,es;q=0.9",
"User-Agent: $agent",
"Cookie: TOKEN=$token;"
);
//
$uuid = uniqid();
//
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, "{
\"data\":{	
\"codTipoDoc\":0,
\"dvEmisor\":	\"$pDigEmpresa\",
\"estadoContab\": \"$estadoContab\",
\"operacion\":	\"$operacion\",
\"ptributario\":	\"$ptributario\",
\"rutEmisor\":	\"$pRutEmpresa\"
},
\"metaData\":{
\"conversationId\":	\"$token\",
\"namespace\":	\"cl.sii.sdi.lob.diii.consdcv.data.api.interfaces.FacadeService/$append_url\",
\"page\":null,
\"transactionId\":\"$uuid\"
}
}");
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER,$header);
//
$response = curl_exec($ch);
curl_close($ch);
print_r($response);

$fp = fopen($FACTRONICA["CSV_DIRECTORIO"]."/".$FACTRONICA["CSV_ARCHIVO"], 'w')or die("ERROR AL GUARDAR EL CSV");
foreach(json_decode($response)->data as $line){
    fputcsv($fp, explode(';', $line), ";");
}
fclose($fp); 
//
echo "<h1>Factronica SpA</h1>";
echo "<h2>SDK - Software Development Kit</h2>";
echo "<br>OK Csv Generado correctamente";
echo "<br><br><a href='".$FACTRONICA["CSV_DIRECTORIO"]."/".$FACTRONICA["CSV_ARCHIVO"]."'>Descargar Archivo CSV</a>";
?>
