<?php

include "../include/header.php";
session_start();
require_once dirname(__FILE__) . '/../PhpWord/Autoloader.php';
\PhpOffice\PhpWord\Autoloader::register();

use PhpOffice\PhpWord\PhpWord;
use PhpOffice\PhpWord\SimpleType\TableAlignment;
use PhpOffice\PhpWord\SimpleType\Jc;

$phpWord = new PhpWord();
$section = $phpWord->addSection();

$con = opendblocal();
$tiene_filtro=false;
$condicion = "";

$query = "SELECT 
    A.id, 
    A.codigo_proveedor, 
    A.codigo_externo, 
    A.especificaciones, 
    A.ubicacion, 
    A.estado_prod, 
    E.descripcion AS estado_prod, 
    C.descripcion AS DES_CATEGORIA,
    A.imagen_prod,
    A.imagen2,
    A.imagen3,
    b.id AS id_bodega, 
    b.descripcion AS bodega,
    U.descripcion AS ubicacion_des
FROM productos A 
LEFT JOIN categorias C ON A.categoria_id = C.ID 
LEFT JOIN estado_prod E ON A.estado_prod = E.id
LEFT JOIN stock s ON A.id = s.producto_id
LEFT JOIN bodegas b ON s.bodega_id = b.id
LEFT JOIN ubicacion U ON A.ubicacion = U.id";


$order = " order by A.fecha_actual DESC";

$bodega = $_SESSION['bodegaidsale'];
$ubicacion = $_GET['v10'];
$var1 = "s.bodega_id = $bodega";

if ($ubicacion != "") {
	if ($tiene_filtro==false) {
		$tiene_filtro = true;
		$condicion = " WHERE A.ubicacion = '$ubicacion' and ".$var1."";
	} else {
		$condicion = $condicion . " AND A.ubicacion '$ubicacion' and ".$var1."";
	}
}

$result = mysqli_query($con,$query.$condicion.$order);
$productos = [];
while ($row = mysqli_fetch_assoc($result)) {
    $productos[] = [
        'key' => $row['id'],
        'codigo_interno' => $row['codigo_proveedor'],
        'codigo_barra' => $row['codigo_externo'],
        'nombre' => $row['especificaciones'],
        'ubicacion' => $row['ubicacion_des'],
        'estado' => $row['estado_prod'],
        'categoria' => $row['DES_CATEGORIA'],
        'imagen_prod' => $row['imagen_prod'],   
        'imagen2' => $row['imagen2'],           
        'imagen3' => $row['imagen3']            
    ];
}
//estilo
$phpWord->addTableStyle('EstiloCuadricula4Enfasis1', [
    'borderSize' => 7,
    'borderColor' => '999999',
    'cellMargin' => 50,
], [
    'bgColor' => 'E6F0FA', 
]);

if (!empty($productos)) {
    $tituloEstilo = ['bold' => true, 'size' => 14];
    $parrafoCentrado = ['alignment' => Jc::CENTER];

    $section->addText("Reporte de Bienes - " . $productos[0]['ubicacion'], $tituloEstilo, $parrafoCentrado);
}

foreach ($productos as $producto) {

    $section->addTextBreak(1);
    $table = $section->addTable('EstiloCuadricula4Enfasis1');

    // Cabecera
    $table->addRow();
    $table->addCell(1500)->addText('Key');
    $table->addCell(2000)->addText('Código Interno');
    $table->addCell(2000)->addText('Código de Barra');
    $table->addCell(3500)->addText('Nombre del Bien');


    $table->addRow();
    $table->addCell(1500)->addText($producto['key']);
    $table->addCell(2000)->addText($producto['codigo_interno']);
    $table->addCell(2000)->addText($producto['codigo_barra']);
    $table->addCell(3500)->addText($producto['nombre']);

    $table->addRow();
    $table->addCell(null, ['gridSpan' => 2])->addText('Estado: ' . $producto['estado']);
    $table->addCell(null, ['gridSpan' => 2])->addText('Principal: ' . $producto['categoria']);

	//imagenes
	$table->addRow();

	$img1 = '../images/productos/' . $producto['imagen_prod'];
	if (!empty($producto['imagen_prod']) && file_exists($img1)) {
		$table->addCell(null, ['gridSpan' => 2])->addImage($img1, ['width' => 100, 'height' => 100]);
	} else {
		$table->addCell(null, ['gridSpan' => 2])->addText('Sin imagen');
	}
	
	$img2 = '../images/productos/' . $producto['imagen2'];
	if (!empty($producto['imagen2']) && file_exists($img2)) {
		$table->addCell(2000)->addImage($img2, ['width' => 100, 'height' => 100]);
	} else {
		$table->addCell(2000)->addText('Sin imagen');
	}

	$img3 = '../images/productos/' . $producto['imagen3'];
	if (!empty($producto['imagen3']) && file_exists($img3)) {
		$table->addCell(2000)->addImage($img3, ['width' => 100, 'height' => 100]);
	} else {
		$table->addCell(2000)->addText('Sin imagen');
	}

}

// Exportar el archivo
$tempFile = tempnam(sys_get_temp_dir(), 'word') . '.docx';
$objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord, 'Word2007');
$objWriter->save($tempFile);

// Forzar descarga
header("Content-Description: File Transfer");
header("Content-Type: application/vnd.openxmlformats-officedocument.wordprocessingml.document");
header("Content-Disposition: attachment; filename=\"Reporte_Bienes.docx\"");
header("Expires: 0");
header("Cache-Control: must-revalidate");
header("Pragma: public");
header("Content-Length: " . filesize($tempFile));

readfile($tempFile);
unlink($tempFile);
exit;
?>


