<?php
require('../fpdf/fpdf.php');
require_once("../include/header.php");

class PDF_MC_Table extends FPDF
{
var $widths;
var $aligns;

function SetWidths($w)
{
    //Set the array of column widths
    $this->widths=$w;
}

function SetAligns($a)
{
    //Set the array of column alignments
    $this->aligns=$a;
}


function SetDash($black=false, $white=false)
    {
        if($black and $white)
            $s=sprintf('[%.3f %.3f] 0 d', $black*$this->k, $white*$this->k);
        else
            $s='[] 0 d';
        $this->_out($s);
    }

function Row($data)
{
    //Calculate the height of the row
    $nb=0;
    for($i=0;$i<count($data);$i++)
        $nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
    $h=5*$nb;
    //Issue a page break first if needed
    $this->CheckPageBreak($h);
    //Draw the cells of the row
    for($i=0;$i<count($data);$i++)
    {
        $w=$this->widths[$i];
        $a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'C';
        //Save the current position
        $x=$this->GetX();
        $y=$this->GetY();
        //Draw the border
        $this->Rect($x,$y,$w,$h);
        //Print the text
        $this->MultiCell($w,5,$data[$i],0,$a);
        //Put the position to the right of the cell
        $this->SetXY($x+$w,$y);
    }
    //Go to the next line
    $this->Ln($h);
}

function Row4($data)
{
    //Calculate the height of the row
    $nb=0;
    for($i=0;$i<count($data);$i++)
        $nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
    $h=5*$nb;
    //Issue a page break first if needed
    $this->CheckPageBreak($h);
    //Draw the cells of the row
    for($i=0;$i<count($data);$i++)
    {
        $w=$this->widths[$i];
       if($i<2){
			$this->SetFont('Arial','B',7);
			$a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'C';
		}else{
			$a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'C';
			$this->SetFont('Arial','B',7);
		}
        //Save the current position
        $x=$this->GetX();
        $y=$this->GetY();
        //Draw the border
        //$this->Rect($x,$y,$w,$h);
		//$this->Line(10,$this->GetY(),170,$this->GetY());
		//$this->Line(10,$this->GetX(),170,$this->GetX());
        //Print the text
        $this->MultiCell($w,5,$data[$i],0,$a);
        //Put the position to the right of the cell
        $this->SetXY($x+$w,$y);
    }
	
	/*$this->SetDash(1,1);
	$this->Line(10,$this->GetY(),198,$this->GetY());
	$this->Ln(7);
	$this->Line(10,$this->GetY(),198,$this->GetY());
	
	$this->SetDash(0,0);*/
    //Go to the next line
	
    $this->Ln($h);
}

function Row1($data)
{
    //Calculate the height of the row
    $nb=0;
    for($i=0;$i<count($data);$i++)
        $nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
    $h=5*$nb;
    //Issue a page break first if needed
    $this->CheckPageBreak($h);
    //Draw the cells of the row
    for($i=0;$i<count($data);$i++)
    {
        $w=$this->widths[$i];
        $a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'C';
        //Save the current position
        $x=$this->GetX();
        $y=$this->GetY();
        //Draw the border
        $this->Rect($x,$y,$w,$h);
        //Print the text
        $this->MultiCell($w,5,$data[$i],0,$a);
        //Put the position to the right of the cell
        $this->SetXY($x+$w,$y);
    }
    //Go to the next line
    $this->Ln($h);
}
function Row2($data)
{
    //Calculate the height of the row
    $nb=0;
    for($i=0;$i<count($data);$i++)
        $nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
    $h=5*$nb;
    //Issue a page break first if needed
    $this->CheckPageBreak($h);
    //Draw the cells of the row
    for($i=0;$i<count($data);$i++)
    {
        $w=$this->widths[$i];
        $a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'C';
        //Save the current position
        $x=$this->GetX();
        $y=$this->GetY();
        //Draw the border
        $this->Rect($x,$y,$w,$h);
        //Print the text
        $this->MultiCell($w,5,$data[$i],0,$a);
        //Put the position to the right of the cell
        $this->SetXY($x+$w,$y);
    }
	
	
    //Go to the next line
    $this->Ln($h);
	/*if($i > 4 ){
			$this->AddPage();
	}*/
}

function CheckPageBreak($h)
{
    //If the height h would cause an overflow, add a new page immediately
    if($this->GetY()+$h>$this->PageBreakTrigger)
        $this->AddPage($this->CurOrientation);
}

function NbLines($w,$txt)
{
    //Computes the number of lines a MultiCell of width w will take
    $cw=&$this->CurrentFont['cw'];
    if($w==0)
        $w=$this->w-$this->rMargin-$this->x;
    $wmax=($w-2*$this->cMargin)*1000/$this->FontSize;
    $s=str_replace("\r",'',$txt);
    $nb=strlen($s);
    if($nb>0 and $s[$nb-1]=="\n")
        $nb--;
    $sep=-1;
    $i=0;
    $j=0;
    $l=0;
    $nl=1;
    while($i<$nb)
    {
        $c=$s[$i];
        if($c=="\n")
        {
            $i++;
            $sep=-1;
            $j=$i;
            $l=0;
            $nl++;
            continue;
        }
        if($c==' ')
            $sep=$i;
        $l+=$cw[$c];
        if($l>$wmax)
        {
            if($sep==-1)
            {
                if($i==$j)
                    $i++;
            }
            else
                $i=$sep+1;
            $sep=-1;
            $j=$i;
            $l=0;
            $nl++;
        }
        else
            $i++;
    }
    return $nl;
}

function Header()
{
    // Logo
    //$this->Image('images/logo5.png',10,6,30);

	$this->Image($GLOBALS['logo_empresa'],250,5,18,0,'');
    // Arial bold 15
    //$this->SetFont('Arial','B',15);
    // Move to the right
    //$this->Cell(80);
    // Title
   // $this->Cell(30,10,'Title',1,0,'C');
    // Line break
    //$this->Ln(10);
	
	$this->SetFont('Arial','B',10);
	//$this->SetTextColor(234, 8, 8);
	//$this->Image('images/logo/imagen_group.jpg',85,5,30,0,'');
	//$this->Image('images/cotizacion_detalles_pago.jpg',150,43,50,0,'');
	//$this->Ln(10);
	$this->Rect(10,5,259,18);
	$this->Cell(260,7,utf8_decode('PLANCHETA DE INVENTARIO'),0,0,'C');
	
	
$this->SetXY(10,5);
$this->SetFont('Arial','B',7);
$this->MultiCell(90,4,utf8_decode(strtoupper($GLOBALS['señor'])),0,'L',false);	
$this->SetXY(10,10);
$this->Ln(15);
$this->SetFont('Arial','',7);
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','B',9);
$this->Cell(28,8,utf8_decode('Establecimiento:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',7);
$this->Cell(95,8,utf8_decode($GLOBALS['descripcion_bod']),'',0,'c');

$this->Ln(7);
$this->SetFont('Arial','',7);
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','B',9);
$this->Cell(28,8,utf8_decode('Ubicación:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',7);
$this->Cell(95,8,utf8_decode($GLOBALS['ubicacion_des']),'',0,'c');

$this->Ln(7);
$this->SetFont('Arial','',7);
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','B',9);
$this->Cell(28,8,utf8_decode('Responsable:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',7);
$this->Cell(95,8,utf8_decode($GLOBALS['usuario_res']),'',0,'c');



	$this->Ln(5);
	$this->SetFont('Arial','',9);
	$this->Rect(10,25,259,27);

//$this->Cell(260,7,strtoupper(utf8_decode('MES DE '.$GLOBALS['var'].' '.$GLOBALS['año'].'')),0,0,'C');

$this->Ln(10);


}

// Page footer
function Footer()
{
	$this->SetXY(10,190);
	$this->SetFont('Arial','B',8);
    // Position at 1.5 cm from bottom
    $this->Cell(45,6,'Nombre Completo','T',0,'C');
	$this->Ln(6);
	$this->Cell(45,6,'JEFATURA',0,0,'C');
	
	$this->SetXY(115,190);
	$this->SetFont('Arial','B',8);
    // Position at 1.5 cm from bottom
    $this->Cell(45,6,'Nombre Completo','T',0,'C');
	$this->Ln(6);
	$this->SetXY(115,196);
	$this->Cell(45,6,'Responsable Inventario',0,0,'C');
	
	$this->SetXY(220,190);
	$this->SetFont('Arial','B',8);
    // Position at 1.5 cm from bottom
    $this->Cell(45,6,'Nombre Completo','T',0,'C');
	$this->Ln(6);
	$this->SetXY(220,196);
	$this->Cell(45,6,'Jefe Departamento',0,0,'C');
    
	$this->SetY(-15);
	$this->SetFont('Arial','I',8);
    $this->Cell(0,10,utf8_decode('Página ').$this->PageNo().'/{nb}',0,0,'R');
	//$this->Image('images/cotizacion_foot.jpg',10,275,190,20,'');
	//$this->Image('images/cotizacion_detalles_pago.jpg',150,240,50,0,'');
}
}
?>