<?php
require('../fpdf/fpdf.php');
require_once("../include/header.php");


class PDF_MC_Table extends FPDF
{
var $widths;
var $aligns;

function SetWidths($w)
{
    //Set the array of column widths
    $this->widths=$w;
}

function SetAligns($a)
{
    //Set the array of column alignments
    $this->aligns=$a;
}

function Row($data)
{
    //Calculate the height of the row
    $nb=0;
    for($i=0;$i<count($data);$i++)
        $nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
    $h=5*$nb;
    //Issue a page break first if needed
    $this->CheckPageBreak($h);
    //Draw the cells of the row
    for($i=0;$i<count($data);$i++)
    {
        $w=$this->widths[$i];
        $a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'C';
        //Save the current position
        $x=$this->GetX();
        $y=$this->GetY();
        //Draw the border
        $this->Rect($x,$y,$w,$h);
        //Print the text
        $this->MultiCell($w,5,$data[$i],0,$a);
        //Put the position to the right of the cell
        $this->SetXY($x+$w,$y);
    }
    //Go to the next line
    $this->Ln($h);
}

function Row1($data)
{
    //Calculate the height of the row
    $nb=0;
    for($i=0;$i<count($data);$i++)
        $nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
    $h=5*$nb;
    //Issue a page break first if needed
    $this->CheckPageBreak($h);
    //Draw the cells of the row
    for($i=0;$i<count($data);$i++)
    {
        $w=$this->widths[$i];
        $a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'C';
        //Save the current position
        $x=$this->GetX();
        $y=$this->GetY();
        //Draw the border
        $this->Rect($x,$y,$w,$h);
        //Print the text
        $this->MultiCell($w,5,$data[$i],0,$a);
        //Put the position to the right of the cell
        $this->SetXY($x+$w,$y);
    }
    //Go to the next line
    $this->Ln($h);
}

function CheckPageBreak($h)
{
    //If the height h would cause an overflow, add a new page immediately
    if($this->GetY()+$h>$this->PageBreakTrigger)
        $this->AddPage($this->CurOrientation);
}

function NbLines($w,$txt)
{
    //Computes the number of lines a MultiCell of width w will take
    $cw=&$this->CurrentFont['cw'];
    if($w==0)
        $w=$this->w-$this->rMargin-$this->x;
    $wmax=($w-2*$this->cMargin)*1000/$this->FontSize;
    $s=str_replace("\r",'',$txt);
    $nb=strlen($s);
    if($nb>0 and $s[$nb-1]=="\n")
        $nb--;
    $sep=-1;
    $i=0;
    $j=0;
    $l=0;
    $nl=1;
    while($i<$nb)
    {
        $c=$s[$i];
        if($c=="\n")
        {
            $i++;
            $sep=-1;
            $j=$i;
            $l=0;
            $nl++;
            continue;
        }
        if($c==' ')
            $sep=$i;
        $l+=$cw[$c];
        if($l>$wmax)
        {
            if($sep==-1)
            {
                if($i==$j)
                    $i++;
            }
            else
                $i=$sep+1;
            $sep=-1;
            $j=$i;
            $l=0;
            $nl++;
        }
        else
            $i++;
    }
    return $nl;
}

function Header()
{
    // Logo
    //$this->Image('images/logo5.png',10,6,30);

	$this->Image('../'.$GLOBALS['logo_empresa'],10,5,33,0,'');
    // Arial bold 15
    //$this->SetFont('Arial','B',15);
    // Move to the right
    //$this->Cell(80);
    // Title
   // $this->Cell(30,10,'Title',1,0,'C');
    // Line break
    //$this->Ln(10);
	
	$this->SetFont('Arial','B',9);
$this->SetTextColor(234, 8, 8);
//$this->Image('images/logo/imagen_group.jpg',85,5,30,0,'');
//$this->Image('images/cotizacion_detalles_pago.jpg',150,43,50,0,'');
//$this->Ln(10);
$this->SetFont('Arial','B',8);
$this->SetTextColor(0, 0, 0);
$this->SetX(25);
$this->Cell(20,5,utf8_decode(''),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->MultiCell(85,5,utf8_decode(strtoupper($GLOBALS['señor'])),0,'J',false);
$this->SetX(152);
$this->SetFont('Arial','B',11);
$this->SetTextColor(234, 8, 8);
$this->SetXY(153,10);
$this->Cell(40,10,utf8_decode('R.U.T. '.$GLOBALS['rut_empresa']),'',0,'c');
$this->SetTextColor(0, 0, 0);
$this->Ln(5);
$this->SetX(25);
$this->Cell(20,7,utf8_decode(''),0,0,'0');
$this->SetFont('Arial','B',8);
$this->SetTextColor(0, 0, 0);
$this->MultiCell(85,5,utf8_decode(strtoupper($GLOBALS['rut_empresa'])),0,'J',false);
$this->SetFont('Arial','B',9);
$this->SetX(145);

$this->Cell(20,7,utf8_decode(''),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(80,7,'',0,0,'c');
$this->SetFont('Arial','B',8);


$this->SetXY(147,19);
$this->SetFont('Arial','B',11);
$this->SetTextColor(234, 8, 8);
$this->Cell(40,10,utf8_decode('REPORTE INVENTARIO'),'',0,'c');
$this->SetTextColor(0,0,0);
$this->SetFont('Arial','B',8);

$this->SetXY(25,20);
$this->Cell(20,7,utf8_decode(''),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->MultiCell(85,5,utf8_decode(strtoupper($GLOBALS['direccion_empresa'])),0,'J',false);

$this->SetX(130);
$this->Cell(20,7,utf8_decode(''),0,0,'0');

$this->SetFont('Arial','B',8);
$this->Ln(5);
$this->SetXY(25,25);
$this->Cell(20,7,utf8_decode(''),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->MultiCell(85,5,utf8_decode(strtoupper($GLOBALS['comuna_empresa'])),0,'J',false);
$this->SetX(145);
$this->Cell(20,7,utf8_decode(''),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',8);

$this->SetFont('Arial','B',8);
$this->Ln(7);
$this->SetXY(25,30);
$this->Cell(20,7,utf8_decode(''),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->MultiCell(85,5,utf8_decode(strtoupper($GLOBALS['giro_empresa'])),0,'J',false);
$this->SetXY(153,28);
$this->SetFont('Arial','B',11);
$this->SetTextColor(234, 8, 8);
$this->Cell(40,10,utf8_decode(" N°  ").right("0000000000".trim($GLOBALS['nroBoleta']),10),'',0,'c');
$this->SetTextColor(0,0,0);
$this->SetFont('Arial','',7);
$this->SetX(150);
$this->Cell(20,7,utf8_decode(''),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',8);
$this->SetDrawColor(234, 8, 8);
$this->SetLineWidth(1);
$this->Rect(140,10,60,27);
$this->SetLineWidth(0);
$this->SetDrawColor(0, 0, 0);
$this->Rect(10,42,190,18);




$this->Ln(15);
$this->SetFont('Arial','',7);
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','B',7);
$this->Cell(25,8,utf8_decode('Fecha:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',7);
$this->Cell(95,8,utf8_decode($GLOBALS['fechaTrasp']),'',0,'c');
$this->SetX(140);
$this->SetTextColor(0, 0, 0);
$this->Cell(20,8,utf8_decode(''),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(35,8,utf8_decode(''),'',0,'c');

$this->Ln(5);
$this->SetFont('Arial','',7);
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','B',7);
$this->Cell(25,8,utf8_decode('Autorizado Por:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',7);
$this->Cell(95,8,utf8_decode($GLOBALS['autorizador']),'',0,'c');
$this->SetX(140);
$this->SetTextColor(0, 0, 0);
$this->Cell(20,8,utf8_decode(''),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(35,8,utf8_decode(''),'',0,'c');

$this->Ln(5);
$this->SetFont('Arial','',7);
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','B',7);
$this->Cell(25,8,utf8_decode('Sucursal:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',7);
$this->Cell(95,8,utf8_decode($GLOBALS['bod1']),'',0,'c');
$this->SetX(140);
$this->SetTextColor(0, 0, 0);
$this->Cell(20,8,utf8_decode(''),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(35,8,utf8_decode(''),'',0,'c');


$this->Ln(10);

}

// Page footer
function Footer()
{
    // Position at 1.5 cm from bottom
	//$this->SetY(-80);
    $this->SetFont('Arial','B',10);
	$this->SetXY(10,238);
	$this->Cell(35,5,utf8_decode('OBSERVACIONES:'),'B',0,'c');
	//$this->Ln(6);
	$this->SetX(48);
	 $this->SetFont('Arial','',9);
	$this->MultiCell(90,5,utf8_decode(strtoupper($GLOBALS['observaciones'])),0,'J',false);
    // Arial italic 8
	$this->SetY(-60);
	
    $this->SetFont('Arial','B',8);
    // Page number
	$this->SetX(10);
	/*$this->Cell(30,6,'OBS',1,0,'1');
	$this->Cell(70,6,'DATOS PARA TRANSFERENCIA BANCARIA',1,0,'1');*/
	
	$this->SetY(-15);
	$this->SetFont('Arial','I',8);
    $this->Cell(0,10,utf8_decode('Página ').$this->PageNo().'/{nb}',0,0,'R');
	//$this->Image('images/cotizacion_foot.jpg',10,275,190,20,'');
	//$this->Image('images/cotizacion_detalles_pago.jpg',150,240,50,0,'');
}
}
?>