<?php
require('../fpdf/fpdf.php');
require_once("../include/header.php");


class PDF_MC_Table extends FPDF
{
var $widths;
var $aligns;

function SetWidths($w)
{
    //Set the array of column widths
    $this->widths=$w;
}

function SetAligns($a)
{
    //Set the array of column alignments
    $this->aligns=$a;
}

function Row($data)
{
    //Calculate the height of the row
    $nb=0;
    for($i=0;$i<count($data);$i++)
        $nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
    $h=5*$nb;
    //Issue a page break first if needed
    $this->CheckPageBreak($h);
    //Draw the cells of the row
    for($i=0;$i<count($data);$i++)
    {
        $w=$this->widths[$i];
		if($i==6){
			$a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'R';
		}else{
			$a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'L';
		}
        //Save the current position
        $x=$this->GetX();
        $y=$this->GetY();
        //Draw the border
        //$this->Rect($x,$y,$w,$h);
        //Print the text
        $this->MultiCell($w,5,$data[$i],'B',$a);
        //Put the position to the right of the cell
        $this->SetXY($x+$w,$y);
    }
    //Go to the next line
    $this->Ln($h);
}

function Row1($data)
{
    //Calculate the height of the row
    $nb=0;
    for($i=0;$i<count($data);$i++)
        $nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
    $h=5*$nb;
    //Issue a page break first if needed
    $this->CheckPageBreak($h);
    //Draw the cells of the row
    for($i=0;$i<count($data);$i++)
    {
        $w=$this->widths[$i];
        if($i==6){
			$a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'R';
		}else{
			$a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'L';
		}
        //Save the current position
        $x=$this->GetX();
        $y=$this->GetY();
        //Draw the border
        //$this->Rect($x,$y,$w,$h);
        //Print the text
        $this->MultiCell($w,5,$data[$i],0,$a);
        //Put the position to the right of the cell
        $this->SetXY($x+$w,$y);
    }
    //Go to the next line
    $this->Ln($h);
}

function CheckPageBreak($h)
{
    //If the height h would cause an overflow, add a new page immediately
    if($this->GetY()+$h>$this->PageBreakTrigger)
        $this->AddPage($this->CurOrientation);
}

function NbLines($w,$txt)
{
    //Computes the number of lines a MultiCell of width w will take
    $cw=&$this->CurrentFont['cw'];
    if($w==0)
        $w=$this->w-$this->rMargin-$this->x;
    $wmax=($w-2*$this->cMargin)*1000/$this->FontSize;
    $s=str_replace("\r",'',$txt);
    $nb=strlen($s);
    if($nb>0 and $s[$nb-1]=="\n")
        $nb--;
    $sep=-1;
    $i=0;
    $j=0;
    $l=0;
    $nl=1;
    while($i<$nb)
    {
        $c=$s[$i];
        if($c=="\n")
        {
            $i++;
            $sep=-1;
            $j=$i;
            $l=0;
            $nl++;
            continue;
        }
        if($c==' ')
            $sep=$i;
        $l+=$cw[$c];
        if($l>$wmax)
        {
            if($sep==-1)
            {
                if($i==$j)
                    $i++;
            }
            else
                $i=$sep+1;
            $sep=-1;
            $j=$i;
            $l=0;
            $nl++;
        }
        else
            $i++;
    }
    return $nl;
}

function Header()
{
    // Logo
    //$this->Image('images/logo5.png',10,6,30);

	$this->Image('../'.$GLOBALS['logo_empresa'],10,8,32,0,'');
    // Arial bold 15
    //$this->SetFont('Arial','B',15);
    // Move to the right
    //$this->Cell(80);
    // Title
   // $this->Cell(30,10,'Title',1,0,'C');
    // Line break
    //$this->Ln(10);
	
	$this->SetFont('Arial','B',9);
$this->SetTextColor(234, 8, 8);
//$this->Image('images/logo/imagen_group.jpg',85,5,30,0,'');
//$this->Image('images/cotizacion_detalles_pago.jpg',150,43,50,0,'');
//$this->Ln(10);

$rtempresa =  substr($GLOBALS['rut_empresa'], 0, 8);
$dv =  substr($GLOBALS['rut_empresa'], 9, 10);
$this->SetFont('Arial','I',9);
$this->SetTextColor(128, 128, 128);
$this->SetX(25);
$this->Cell(20,5,utf8_decode(''),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->MultiCell(85,5,utf8_decode(strtoupper($GLOBALS['señor'])),0,'J',false);
$this->SetX(152);
$this->SetFont('Arial','B',11);
$this->SetTextColor(234, 8, 8);
$this->SetXY(151,10);
$this->Cell(40,10,utf8_decode('R.U.T.: '.number_format($rtempresa, 0, ",", ".").'-'.$dv),'',0,'c');
$this->SetTextColor(0, 0, 0);
$this->Ln(5);
$this->SetX(25);
$this->Cell(20,7,utf8_decode(''),0,0,'0');
$this->SetFont('Arial','B',7);
$this->SetTextColor(0, 0, 0);
$this->MultiCell(85,5,utf8_decode(strtoupper($GLOBALS['giro_empresa'])),0,'J',false);
$this->SetFont('Arial','B',9);
$this->SetX(145);

$this->Cell(20,7,utf8_decode(''),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(80,7,'',0,0,'c');
$this->SetFont('Arial','B',8);


$this->SetXY(150,19);
$this->SetFont('Arial','B',11);
$this->SetTextColor(234, 8, 8);
$this->Cell(40,10,utf8_decode('GUIA ELECTRONICA'),'',0,'c');
$this->SetTextColor(0,0,0);
$this->SetFont('Arial','B',6.5);

$this->SetXY(25,20);
$this->Cell(20,7,utf8_decode(''),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->MultiCell(105,5,utf8_decode(strtoupper('CASA MATRIZ: NUEVA LOS LEONES 07, OFICINA 503 PROVIDENCIA, SANTIAGO')),0,'J',false);

$this->SetX(130);
$this->Cell(20,7,utf8_decode(''),0,0,'0');

$this->SetFont('Arial','B',6.5);
$this->Ln(3);
$this->SetXY(25,25);
$this->Cell(20,7,utf8_decode(''),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->MultiCell(105,5,utf8_decode(strtoupper('SUCURSAL: GENERAL HOLLEY N° 50 LOCAL 19 PROVIDENCIA, SANTIAGO')),0,'J',false);
$this->SetX(145);
$this->Cell(20,7,utf8_decode(''),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',8);

$this->SetFont('Arial','B',6.5);
$this->Ln(7);
$this->SetXY(25,30);
$this->Cell(20,7,utf8_decode(''),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->MultiCell(85,5,utf8_decode(strtoupper('EMAIL: NPADILLA@SILLASALMAYORCHILE.CL')),0,'J',false);

$this->Ln(7);
$this->SetXY(25,35);
$this->Cell(20,7,utf8_decode(''),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->MultiCell(85,5,utf8_decode(strtoupper('TELEFONO: 2 25000994')),0,'J',false);

$this->SetXY(145,28);
$this->SetFont('Arial','B',11);
$this->SetTextColor(234, 8, 8);
$this->Cell(40,10,utf8_decode(" N° FOLIO NO ASIGNADO "),'',0,'c');


$this->SetXY(150,38);
$this->Cell(20,7,utf8_decode('S.I.I. - PROVIDENCIA'),0,0,'0');




$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',8);
$this->SetDrawColor(234, 8, 8);
$this->SetLineWidth(1);
$this->Rect(140,10,60,27);
$this->SetLineWidth(0);
$this->SetDrawColor(0, 0, 0);
//$this->Rect(10,43,190,27);



$this->Ln(7);
$this->SetFont('Arial','',7);
$this->SetTextColor(0, 0, 0);
$this->Cell(60,8,strtoupper(utf8_decode('PROVIDENCIA, '.$GLOBALS['dia'].' de '.$GLOBALS['var'].' de '.$GLOBALS['anio'])),0,0,'0');


$this->Ln(10);
$this->SetFont('Arial','B',7);
$this->SetTextColor(0, 0, 0);
$this->Cell(25,8,utf8_decode('SEÑOR(ES):'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',7);
$this->Cell(95,8,utf8_decode($GLOBALS['rsocialcliente']),'',0,'c');
/*$this->SetX(140);
$this->SetTextColor(0, 0, 0);
$this->Cell(20,8,utf8_decode('Fecha Emisión:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(35,8,utf8_decode($GLOBALS['fechaBoleta']),'',0,'c');*/

$this->Ln(5);
$this->SetFont('Arial','B',7);
$this->SetTextColor(0, 0, 0);
$this->Cell(25,8,utf8_decode('R.U.T:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',7);
$this->Cell(95,8,utf8_decode($GLOBALS['rutCliente']),'',0,'c');
$this->SetX(120);
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','B',7);
$this->Cell(25,8,utf8_decode('Traslado (os):'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',7);
if($GLOBALS['tdocref1']==1){
$this->Cell(35,8,utf8_decode('Operación Constituye Traslado'),0,0,'0');
}else{
$this->Cell(35,8,utf8_decode('Operación Constituye Venta'),0,0,'0');    
}

$this->Ln(5);
$this->SetFont('Arial','B',7);
$this->SetTextColor(0, 0, 0);
$this->Cell(25,8,utf8_decode('GIRO:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',7);
$this->Cell(95,8,utf8_decode($GLOBALS['girocliente']),'',0,'c');
/*$this->SetX(140);
$this->SetTextColor(0, 0, 0);
$this->Cell(20,8,utf8_decode('Teléfono:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(35,8,utf8_decode($GLOBALS['fonocliente']),'',0,'c');*/
$this->Ln(5);
$this->SetFont('Arial','B',7);
$this->SetTextColor(0, 0, 0);
$this->Cell(25,8,utf8_decode('DIRECCIÓN:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',7);
$this->Cell(95,8,utf8_decode($GLOBALS['direccioncliente']),'',0,'c');
/*$this->SetX(140);
$this->SetTextColor(0, 0, 0);
$this->Cell(20,8,utf8_decode('Mail:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(35,8,utf8_decode($GLOBALS['emaicliente']),'',0,'c');*/
$this->Ln(5);
$this->SetFont('Arial','B',7);
$this->SetTextColor(0, 0, 0);
$this->Cell(25,8,utf8_decode('COMUNA:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',7);
$this->Cell(95,8,utf8_decode($GLOBALS['comunacliente']),'',0,'c');

$this->Ln(5);
$this->SetFont('Arial','B',7);
$this->SetTextColor(0, 0, 0);
$this->Cell(25,8,utf8_decode('CIUDAD:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',7);
$this->Cell(95,8,utf8_decode($GLOBALS['ciudadcliente']),'',0,'c');

$this->Ln(5);
$this->SetFont('Arial','B',7);
$this->SetTextColor(0, 0, 0);
$this->Cell(25,8,utf8_decode('Referencia (as):'),0,0,'0');
$this->SetFont('Arial','',7);
if($GLOBALS['tdocref1']!=0){
$q1 = "select descripcion from tipo_documentos_ref where codigo = ".$GLOBALS['tdocref1']."";
$r1 = mysqli_query($con,$q1);
while($f1 = mysqli_fetch_array($r1)){
    $descripcionref = $f1['descripcion'];
}

$this->Cell(25,8,strtoupper(utf8_decode($descripcionref).' FOLIO '.$GLOBALS['foliodocref1'].' DEL '.$GLOBALS['fechadocref1']),0,0,'0');
}

/*
if($GLOBALS['tdocref2']!=0){

$this->Ln(5);
$this->SetX(35);
$q2 = "select descripcion from tipo_documentos_ref where codigo = ".$GLOBALS['tdocref2']."";
$r2 = mysqli_query($con,$q2);
while($f2 = mysqli_fetch_array($r2)){
	$descripcionref2 = $f2['descripcion'];
}

$this->Cell(25,8,strtoupper(utf8_decode($descripcionref2).' FOLIO '.$GLOBALS['foliodocref2'].' DEL '.$GLOBALS['fechadocref2']),0,0,'0');
}*/
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',7);
//$this->Cell(95,8,utf8_decode('GUIA DE DESPACHO ELECTRONICA FOLIO 0 DEL 2017-09-01'),'',0,'c');
/*$this->SetX(140);
$this->SetTextColor(0, 0, 0);
$this->Cell(20,8,utf8_decode('Forma Pago:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(35,8,utf8_decode(''),'',0,'c');*/
$this->Ln(10);

}

// Page footer
function Footer()
{
    // Position at 1.5 cm from bottom
	$this->SetY(-80);
    $this->SetFont('Arial','B',10);
	//$this->Cell(35,5,utf8_decode('OBSERVACIONES:'),'B',0,'c');
	//$this->Ln(6);
	//$this->SetX(48);
	 //$this->SetFont('Arial','',9);
	//$this->MultiCell(130,5,utf8_decode(strtoupper($GLOBALS['observaciones'])),0,'J',false);
    // Arial italic 8
	$this->SetY(-70);
	
    $this->SetFont('Arial','B',8);
    // Page number
	/*$this->SetX(10);
	$this->Cell(30,6,'OBS',1,0,'1');
	$this->Cell(70,6,'DATOS PARA TRANSFERENCIA BANCARIA',1,0,'1');*/
	$this->SetLineWidth(0.4);
	$this->Rect(125,225,75,30);
	$this->SetLineWidth(0);
	$this->SetX(130);
	$this->SetFont('Arial','B',8);
	$this->Cell(30,6,'NETO',0,0,'1');
	$this->SetFont('Arial','',8);
	$this->Cell(5,6,'$',0,0,'L');
	$this->Cell(25,6,number_format($GLOBALS['netot'], 0, ",", "."),0,0,'R');
	$this->SetFont('Arial','',8);
	$this->Ln(6);
	/*$this->Cell(30,6,'NOMBRE',1,0,'1');
	$this->Cell(70,6,utf8_decode($GLOBALS['nombre_empresa_t']),1,0,'1');*/
	$this->SetFont('Arial','B',8);
	$this->SetX(130);
	$this->Cell(30,6,'EXENTO','',0,'1');
	$this->SetFont('Arial','',8);
	$this->Cell(5,6,'$',0,0,'L');
	$this->Cell(25,6,'0','',0,'R');
	$this->Ln(6);
	/*$this->Cell(30,6,'RUT',1,0,'1');
	$this->Cell(70,6,utf8_decode($GLOBALS['rut_empresa_t']),1,0,'1');*/
	$this->SetFont('Arial','B',8);
	$this->SetX(130);
	$this->Cell(30,6,'I.V.A. 19%','',0,'1');
	$this->SetFont('Arial','',8);
	$this->Cell(5,6,'$',0,0,'L');
	$this->Cell(25,6,number_format($GLOBALS['ivat'], 0, ",", "."),'',0,'R');
	$this->Ln(6);
	/*$this->Cell(30,6,'BANCO/ CTA',1,0,'1');
	$this->Cell(70,6,utf8_decode($GLOBALS['cuenta_empresa_t']),1,0,'1');*/
	$this->SetFont('Arial','B',8);
	$this->SetX(130);
	$this->Cell(30,6,'TOTAL','',0,'1');
	$this->SetFont('Arial','',8);
	$this->Cell(5,6,'$',0,0,'L');
	$this->Cell(25,6,number_format($GLOBALS['montot'], 0, ",", "."),'',0,'R');
	$this->Ln(12);
	$this->SetX(125);
	$this->Cell(30,6,utf8_decode('OBSERVACIÓN (ES):'),'',0,'1');
	$this->MultiCell(40,5,utf8_decode($GLOBALS['observaciones']),0,'J',false);
	$this->SetLineWidth(0.4);
	$this->Rect(125,257,75,23);
	$this->SetLineWidth(0);
	/*$this->Cell(30,6,'CORREO',1,0,'1');
	$this->Cell(70,6,utf8_decode($GLOBALS['correo_empresa_t']),1,0,'1');*/
	/*$this->SetX(130);
	$this->Cell(30,6,'PRECIO FINAL','',0,'1');
	$this->SetFont('Arial','',8);
	$this->Cell(30,6,number_format($GLOBALS['montot'], 0, ",", "."),'',0,'R');
	$this->Ln(6);*/
	/*$this->Cell(30,6,'FONO',1,0,'1');
	$this->Cell(70,6,utf8_decode($GLOBALS['telefono_empresa_t']),1,0,'1');*/
	/*$this->SetX(130);
	$this->Cell(30,6,'OBSERVACIONES',1,0,'1');
	$this->SetFont('Arial','',8);
	$this->Cell(30,6,$GLOBALS['med_pago'],1,0,'R');
	$this->Ln(6);
	$this->SetX(130);
	$this->Cell(30,6,'MEDIO DE PAGO',1,0,'1');
	$this->SetFont('Arial','',8);
	$this->Cell(30,6,$GLOBALS['observaciones'],1,0,'R');*/
	$this->SetY(-15);
	$this->SetFont('Arial','I',8);
    //$this->Cell(0,10,utf8_decode('Página ').$this->PageNo().'/{nb}',0,0,'R');
	//$this->Image('images/cotizacion_foot.jpg',10,275,190,20,'');
	//$this->Image('images/cotizacion_detalles_pago.jpg',150,240,50,0,'');
}
}
?>