<?php
require('../fpdf/fpdf.php');
require_once("../include/header.php");


class PDF_MC_Table extends FPDF
{
var $widths;
var $aligns;

function SetWidths($w)
{
    //Set the array of column widths
    $this->widths=$w;
}

function SetAligns($a)
{
    //Set the array of column alignments
    $this->aligns=$a;
}


function SetDash($black=false, $white=false)
    {
        if($black and $white)
            $s=sprintf('[%.3f %.3f] 0 d', $black*$this->k, $white*$this->k);
        else
            $s='[] 0 d';
        $this->_out($s);
    }

function Row($data)
{
    //Calculate the height of the row
    $nb=0;
    for($i=0;$i<count($data);$i++)
        $nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
    $h=5*$nb;
    //Issue a page break first if needed
    $this->CheckPageBreak($h);
    //Draw the cells of the row
    for($i=0;$i<count($data);$i++)
    {
        $w=$this->widths[$i];
        $a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'C';
        //Save the current position
        $x=$this->GetX();
        $y=$this->GetY();
        //Draw the border
        $this->Rect($x,$y,$w,$h);
        //Print the text
        $this->MultiCell($w,5,$data[$i],0,$a);
        //Put the position to the right of the cell
        $this->SetXY($x+$w,$y);
    }
    //Go to the next line
    $this->Ln($h);
}

function Row4($data)
{
    //Calculate the height of the row
    $nb=0;
    for($i=0;$i<count($data);$i++)
        $nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
    $h=5*$nb;
    //Issue a page break first if needed
    $this->CheckPageBreak($h);
    //Draw the cells of the row
    for($i=0;$i<count($data);$i++)
    {
        $w=$this->widths[$i];
       if($i<2){
			$this->SetFont('Arial','B',7);
			$a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'C';
		}else{
			$a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'C';
			$this->SetFont('Arial','B',7);
		}
        //Save the current position
        $x=$this->GetX();
        $y=$this->GetY();
        //Draw the border
        //$this->Rect($x,$y,$w,$h);
		//$this->Line(10,$this->GetY(),170,$this->GetY());
		//$this->Line(10,$this->GetX(),170,$this->GetX());
        //Print the text
        $this->MultiCell($w,5,$data[$i],0,$a);
        //Put the position to the right of the cell
        $this->SetXY($x+$w,$y);
    }
	
	/*$this->SetDash(1,1);
	$this->Line(10,$this->GetY(),198,$this->GetY());
	$this->Ln(7);
	$this->Line(10,$this->GetY(),198,$this->GetY());
	
	$this->SetDash(0,0);*/
    //Go to the next line
	
    $this->Ln($h);
}

function Row1($data)
{
    //Calculate the height of the row
    $nb=0;
    for($i=0;$i<count($data);$i++)
        $nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
    $h=6*$nb;
    //Issue a page break first if needed
    $this->CheckPageBreak($h);
    //Draw the cells of the row
    for($i=0;$i<count($data);$i++)
    {
        $w=$this->widths[$i];
        $a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'C';
        //Save the current position
        $x=$this->GetX();
        $y=$this->GetY();
        //Draw the border
        $this->Rect($x,$y,$w,$h);
        //Print the text
        $this->MultiCell($w,8,$data[$i],0,$a);
        //Put the position to the right of the cell
        $this->SetXY($x+$w,$y);
    }
    //Go to the next line
    $this->Ln($h);
}
function Row2($data)
{
    //Calculate the height of the row
    $nb=0;
    for($i=0;$i<count($data);$i++)
        $nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
    $h=5*$nb;
    //Issue a page break first if needed
    $this->CheckPageBreak($h);
    //Draw the cells of the row
    for($i=0;$i<count($data);$i++)
    {
        $w=$this->widths[$i];
        $a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'C';
        //Save the current position
        $x=$this->GetX();
        $y=$this->GetY();
        //Draw the border
        $this->Rect($x,$y,$w,$h);
        //Print the text
        $this->MultiCell($w,5,$data[$i],0,$a);
        //Put the position to the right of the cell
        $this->SetXY($x+$w,$y);
    }
	
	
    //Go to the next line
    $this->Ln($h);
	/*if($i > 4 ){
			$this->AddPage();
	}*/
}

function CheckPageBreak($h)
{
    //If the height h would cause an overflow, add a new page immediately
    if($this->GetY()+$h>$this->PageBreakTrigger)
        $this->AddPage($this->CurOrientation);
}

function NbLines($w,$txt)
{
    //Computes the number of lines a MultiCell of width w will take
    $cw=&$this->CurrentFont['cw'];
    if($w==0)
        $w=$this->w-$this->rMargin-$this->x;
    $wmax=($w-2*$this->cMargin)*1000/$this->FontSize;
    $s=str_replace("\r",'',$txt);
    $nb=strlen($s);
    if($nb>0 and $s[$nb-1]=="\n")
        $nb--;
    $sep=-1;
    $i=0;
    $j=0;
    $l=0;
    $nl=1;
    while($i<$nb)
    {
        $c=$s[$i];
        if($c=="\n")
        {
            $i++;
            $sep=-1;
            $j=$i;
            $l=0;
            $nl++;
            continue;
        }
        if($c==' ')
            $sep=$i;
        $l+=$cw[$c];
        if($l>$wmax)
        {
            if($sep==-1)
            {
                if($i==$j)
                    $i++;
            }
            else
                $i=$sep+1;
            $sep=-1;
            $j=$i;
            $l=0;
            $nl++;
        }
        else
            $i++;
    }
    return $nl;
}

function Header()
{
    // Logo
    //$this->Image('images/logo5.png',10,6,30);

	$this->Image($GLOBALS['logo_empresa'],10,5,18,0,'');
	
	$this->Image('../bienes_qr/'.$GLOBALS['idboleta'].'.png',250,6,16,0,'');
	if($GLOBALS['imagen_producto']!=""){
	$this->Image('../images/productos/'.$GLOBALS['imagen_producto'],200,38,40,0,'');
	}
    // Arial bold 15
    //$this->SetFont('Arial','B',15);
    // Move to the right
    //$this->Cell(80);
    // Title
   // $this->Cell(30,10,'Title',1,0,'C');
    // Line break
    //$this->Ln(10);
	
	$this->SetFont('Arial','B',10);
	//$this->SetTextColor(234, 8, 8);
	//$this->Image('images/logo/imagen_group.jpg',85,5,30,0,'');
	//$this->Image('images/cotizacion_detalles_pago.jpg',150,43,50,0,'');
	//$this->Ln(10);
$this->Rect(10,5,259,18);
$this->Cell(260,7,utf8_decode('FICHA TÉCNICA'),0,0,'C');

$this->Ln(5);
$this->SetFont('Arial','',9);

$this->Cell(260,7,strtoupper(utf8_decode($GLOBALS['nombre']).' '.$GLOBALS['codigo']),0,0,'C');
$this->SetX(222);
//$this->Cell(40,7,utf8_decode('CERTIFICADO N° '.$GLOBALS['n_folio']),0,0,'L');



$this->Rect(10,30,259,50);


$this->Ln(15);
$this->SetFont('Arial','B',9);
$this->Cell(259,7,utf8_decode('Información Técnica'),'B',0,'C');
$this->Ln(8);



$this->SetFont('Arial','',7);
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','B',9);
$this->Cell(30,8,utf8_decode('Código:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',9);
$this->Cell(95,8,utf8_decode($GLOBALS['categoria']),'',0,'c');

$this->SetX(120);
$this->SetFont('Arial','B',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(30,8,utf8_decode('N° O.C:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',9);
$this->Cell(95,8,utf8_decode($GLOBALS['num_oc']),'',0,'c');

//fila tipos
if($GLOBALS['marca_id']==2){
$this->SetX(183);
$this->SetFont('Arial','B',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(30,8,utf8_decode('Patente:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',9);
$this->Cell(95,8,utf8_decode($GLOBALS['patente_v']),'',0,'c');
}else if($GLOBALS['marca_id']==3){
$this->SetX(183);
$this->SetFont('Arial','B',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(34,8,utf8_decode('Valor de la Propiedad:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',9);
$this->Cell(95,8,utf8_decode($GLOBALS['valor_propiedad_p']),'',0,'c');	
}else{
$this->SetX(183);
$this->SetFont('Arial','B',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(30,8,utf8_decode('N° Serie:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',9);
$this->Cell(95,8,utf8_decode($GLOBALS['num_serie']),'',0,'c');
	
}

$this->Ln(5);
$this->SetFont('Arial','',7);
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','B',9);
$this->Cell(30,8,utf8_decode('Categoría:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',9);
$this->Cell(95,8,utf8_decode($GLOBALS['categoria']),'',0,'c');
$this->SetX(120);
$this->SetFont('Arial','B',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(30,8,utf8_decode('N° Factura:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',9);
$this->Cell(95,8,utf8_decode($GLOBALS['num_factura']),'',0,'c');

//fila tipos
if($GLOBALS['marca_id']==2){
$this->SetX(183);
$this->SetFont('Arial','B',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(30,8,utf8_decode('Sigla:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',9);
$this->Cell(95,8,utf8_decode($GLOBALS['sigla_v']),'',0,'c');
}else if($GLOBALS['marca_id']==3){
$this->SetX(183);
$this->SetFont('Arial','B',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(36,8,utf8_decode('Registro Conservador:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',9);
$this->Cell(95,8,utf8_decode($GLOBALS['registro_conservador_p']),'',0,'c');	
}else{
$this->SetX(183);
$this->SetFont('Arial','B',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(30,8,utf8_decode('Fabricante:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',9);
$this->Cell(95,8,utf8_decode($GLOBALS['fabricante']),'',0,'c');
	
}


$this->Ln(5);
$this->SetFont('Arial','',7);
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','B',9);
$this->Cell(30,8,utf8_decode('Sub Categoría:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',9);
$this->Cell(95,8,utf8_decode($GLOBALS['marca']),'',0,'c');
$this->SetX(120);
$this->SetFont('Arial','B',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(30,8,utf8_decode('Periodo Garantía:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',9);
$this->Cell(95,8,utf8_decode($GLOBALS['periodo_garantia']),'',0,'c');


//fila tipos
if($GLOBALS['marca_id']==2){
$this->SetX(183);
$this->SetFont('Arial','B',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(30,8,utf8_decode('Chasis:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',9);
$this->Cell(95,8,utf8_decode($GLOBALS['chasis_v']),'',0,'c');
}else if($GLOBALS['marca_id']==3){
$this->SetX(183);
$this->SetFont('Arial','B',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(30,8,utf8_decode('Rol Propiedad:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',9);
$this->Cell(95,8,utf8_decode($GLOBALS['rol_p']),'',0,'c');	
}else{
$this->SetX(183);
$this->SetFont('Arial','B',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(30,8,utf8_decode('Modelo:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',9);
$this->Cell(95,8,utf8_decode($GLOBALS['modelo_activo']),'',0,'c');
	
}



$this->Ln(5);
$this->SetFont('Arial','',7);
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','B',9);
$this->Cell(30,8,utf8_decode('Atributo:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',9);
$this->Cell(95,8,utf8_decode($GLOBALS['modelo']),'',0,'c');
$this->SetX(120);
$this->SetFont('Arial','B',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(30,8,utf8_decode('Inicio Garantía:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',9);
$this->Cell(95,8,$GLOBALS['fecha_garantia_e'],'',0,'c');

//fila tipos

if($GLOBALS['marca_id']==2){
$this->SetX(183);
$this->SetFont('Arial','B',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(30,8,utf8_decode('Motor:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',9);
$this->Cell(95,8,utf8_decode($GLOBALS['motor_v']),'',0,'c');
}else if($GLOBALS['marca_id']==3){


}else{
$this->SetX(183);
$this->SetFont('Arial','B',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(30,8,utf8_decode('Valor Equipo:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',9);
$this->Cell(95,8,utf8_decode($GLOBALS['valor_equipo']),'',0,'c');
	
}

$this->Ln(5);
$this->SetFont('Arial','',7);
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','B',9);
$this->Cell(30,8,utf8_decode('Estado:'),0,0,'0');
$this->SetFont('Arial','',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(95,8,utf8_decode($GLOBALS['estado1']),'',0,'c');
$this->SetX(120);
$this->SetFont('Arial','B',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(30,8,utf8_decode('Precio:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',9);
$this->Cell(95,8,number_format($GLOBALS['psale_c_iva'], 0, ",", "."),'',0,'c');
//fila tipos

if($GLOBALS['marca_id']==2){
$this->SetX(183);
$this->SetFont('Arial','B',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(30,8,utf8_decode('Tipo Vehículo:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',9);
$this->Cell(95,8,utf8_decode($GLOBALS['tipo_vehiculo_v']),'',0,'c');
}else if($GLOBALS['marca_id']==3){
	
}else{
$this->SetX(183);
$this->SetFont('Arial','B',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(30,8,utf8_decode('Año Instalación:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',9);
$this->Cell(95,8,utf8_decode($GLOBALS['anio_instalacion']),'',0,'c');
	
}


$this->Ln(5);
$this->SetFont('Arial','',7);
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','B',9);
$this->Cell(30,8,utf8_decode('Descripción:'),0,0,'0');
$this->SetFont('Arial','',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(95,8,utf8_decode($GLOBALS['descripcion1']),'',0,'c');


//fila tipos
if($GLOBALS['marca_id']==2){
$this->SetX(183);
$this->SetFont('Arial','B',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(30,8,utf8_decode('Mes Revisión:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',9);
$this->Cell(95,8,utf8_decode($GLOBALS['mes_revision_v']),'',0,'c');
}

$this->Ln(5);
$this->SetFont('Arial','',7);
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','B',9);
$this->Cell(30,8,utf8_decode('Tipo:'),0,0,'0');
$this->SetFont('Arial','',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(95,8,utf8_decode($GLOBALS['fecha_inventario']),'',0,'c');
$this->Ln(5);
$this->SetFont('Arial','',7);
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','B',9);
$this->Cell(30,8,utf8_decode('Registro de Baja:'),0,0,'0');
$this->SetFont('Arial','',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(95,8,utf8_decode($GLOBALS['registro_baja']),'',0,'c');
$this->Ln(5);
$this->SetFont('Arial','B',9);
$this->Cell(259,8,utf8_decode('Caracteristicas:'),'B',0,'C');

$this->SetFont('Arial','',9);
$this->SetXY(10,86);
$this->MultiCell(250,4,utf8_decode($GLOBALS['caracterizticas']),0,'J');

$this->SetXY(10,78);
$this->Rect(10,80,259,19);

$this->Rect(10,99,129,40);
$this->Rect(139,99,130,40);
$this->Ln(25);
$this->SetFont('Arial','B',9);
$this->Cell(129,7,utf8_decode('Contenido'),'B',0,'C');
$this->SetXY(10,110);
$this->SetFont('Arial','',9);
$this->MultiCell(129,4,utf8_decode($GLOBALS['contenido']),0,'J');


$this->SetFont('Arial','B',9);
$this->SetXY(139,103);
$this->Cell(130,7,utf8_decode('Descripción Adicional'),'B',0,'C');

$this->SetXY(139,110);
$this->SetFont('Arial','',9);
$this->MultiCell(129,4,utf8_decode($GLOBALS['descripcion_adicional']),0,'J');
 //$this->MultiCell(250,5,utf8_decode($GLOBALS['señor'].', Rut '.$GLOBALS['rut_empresa'].', representada por Sr./Sra. '.$GLOBALS['r_legal_nombre'].' Rut: '.$GLOBALS['r_legal_rut'].', Certifica que al Sr./Sra. '.$GLOBALS['nombre_trabajador'].' Rut: '.$GLOBALS['rut_trabajador'].' en su calidad de empleado dependiente, jubilado, pensionado o montepiado, según corresponda, durante el año  '.$GLOBALS['anio'].', se le han  pagado las rentas que se indican y sobre las cuales se le practicaron las retenciones de impuestos que se señalan:'),0,'J');

$this->Ln(30);

$this->SetFont('Arial','B',9);
$this->Cell(259,8,utf8_decode('Historial:'),1,0,'C');
$this->Ln(8);
}

// Page footer
function Footer()
{
    // Position at 1.5 cm from bottom

    // Arial italic 8
	/*$this->SetY(-60);
    $this->SetFont('Arial','B',8);
    // Page number
	$this->SetX(10);
	$this->Cell(30,6,'OBS',1,0,'1');
	$this->Cell(70,6,'DATOS PARA TRANSFERENCIA BANCARIA',1,0,'1');
	$this->SetX(130);
	$this->Cell(30,6,'SUBTOTAL','B',0,'1');
	$this->SetFont('Arial','',8);
	$this->Cell(30,6,number_format($GLOBALS['netot'], 0, ",", "."),'B',0,'R');
	$this->SetFont('Arial','',8);
	$this->Ln(6);
	$this->Cell(30,6,'NOMBRE',1,0,'1');
	$this->Cell(70,6,'',1,0,'1');
	$this->SetX(130);
	$this->Cell(30,6,'DESCUENTO','T',0,'1');
	$this->SetFont('Arial','',8);
	$this->Cell(30,6,'','T',0,'R');
	$this->Ln(6);
	$this->Cell(30,6,'RUT',1,0,'1');
	$this->Cell(70,6,'',1,0,'1');
	$this->SetX(130);
	$this->Cell(30,6,'PRECIO NETO','',0,'1');
	$this->SetFont('Arial','',8);
	$this->Cell(30,6,number_format($GLOBALS['netot'], 0, ",", "."),'',0,'R');
	$this->Ln(6);
	$this->Cell(30,6,'BANCO/ CTA',1,0,'1');
	$this->Cell(70,6,'BANCO DE CHILE/CTA CORRIENTE:',1,0,'1');
	$this->SetX(130);
	$this->Cell(30,6,'IVA','',0,'1');
	$this->SetFont('Arial','',8);
	$this->Cell(30,6,number_format($GLOBALS['ivat'], 0, ",", "."),'',0,'R');
	$this->Ln(6);
	$this->Cell(30,6,'CORREO',1,0,'1');
	$this->Cell(70,6,'',1,0,'1');
	$this->SetX(130);
	$this->Cell(30,6,'PRECIO FINAL','',0,'1');
	$this->SetFont('Arial','',8);
	$this->Cell(30,6,number_format($GLOBALS['montot'], 0, ",", "."),'',0,'R');
	$this->Ln(6);
	$this->Cell(30,6,'FONO',1,0,'1');
	$this->Cell(70,6,'225260218',1,0,'1');*/
	/*$this->SetX(130);
	$this->Cell(30,6,'OBSERVACIONES',1,0,'1');
	$this->SetFont('Arial','',8);
	$this->Cell(30,6,$GLOBALS['med_pago'],1,0,'R');
	$this->Ln(6);
	$this->SetX(130);
	$this->Cell(30,6,'MEDIO DE PAGO',1,0,'1');
	$this->SetFont('Arial','',8);
	$this->Cell(30,6,$GLOBALS['observaciones'],1,0,'R');*/
	$this->SetFont('Arial','B',10);
	//$this->Ln(6);
	//$this->MultiCell(250,5,utf8_decode('LAS ESPECIES QUE FIGURAN EN ESTA HOJA MURAL NO DEBEN SER TRASLADADAS SIN SU RESPECTIVO RESPALDO MEDIANTE UN TRASPASO FORMAL MEDIANTE ORDINARIO DIRIGIDO AL JEFE DE ADMINISTRACIÓN Y FINANZAS DE ACUERDO AL CIRCULAR N° 314 DEL 20/06/2016 U OTRA FORMA DE COMUNICACIÓN QUE DEFINA LA DIRECCIÓN DEL ESTABLECIMIENTO'),0,'J');

	$this->SetY(-15);
	$this->SetFont('Arial','I',8);
    //$this->Cell(0,10,utf8_decode('Página ').$this->PageNo().'/{nb}',0,0,'R');
	//$this->Image('images/cotizacion_foot.jpg',10,275,190,20,'');
	//$this->Image('images/cotizacion_detalles_pago.jpg',150,240,50,0,'');
}
}
?>