<?php
require('../fpdf/fpdf.php');
require_once("../include/header.php");


class PDF_MC_Table extends FPDF
{
var $widths;
var $aligns;

function SetWidths($w)
{
    //Set the array of column widths
    $this->widths=$w;
}

function SetAligns($a)
{
    //Set the array of column alignments
    $this->aligns=$a;
}


function SetDash($black=false, $white=false)
    {
        if($black and $white)
            $s=sprintf('[%.3f %.3f] 0 d', $black*$this->k, $white*$this->k);
        else
            $s='[] 0 d';
        $this->_out($s);
    }

function Row($data)
{
    //Calculate the height of the row
    $nb=0;
    for($i=0;$i<count($data);$i++)
        $nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
    $h=5*$nb;
    //Issue a page break first if needed
    $this->CheckPageBreak($h);
    //Draw the cells of the row
    for($i=0;$i<count($data);$i++)
    {
        $w=$this->widths[$i];
        $a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'C';
        //Save the current position
        $x=$this->GetX();
        $y=$this->GetY();
        //Draw the border
        $this->Rect($x,$y,$w,$h);
        //Print the text
        $this->MultiCell($w,5,$data[$i],0,$a);
        //Put the position to the right of the cell
        $this->SetXY($x+$w,$y);
    }
    //Go to the next line
    $this->Ln($h);
}

function Row4($data)
{
    //Calculate the height of the row
    $nb=0;
    for($i=0;$i<count($data);$i++)
        $nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
    $h=5*$nb;
    //Issue a page break first if needed
    $this->CheckPageBreak($h);
    //Draw the cells of the row
    for($i=0;$i<count($data);$i++)
    {
        $w=$this->widths[$i];
       if($i<2){
			$this->SetFont('Arial','B',7);
			$a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'C';
		}else{
			$a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'C';
			$this->SetFont('Arial','B',7);
		}
        //Save the current position
        $x=$this->GetX();
        $y=$this->GetY();
        //Draw the border
        //$this->Rect($x,$y,$w,$h);
		//$this->Line(10,$this->GetY(),170,$this->GetY());
		//$this->Line(10,$this->GetX(),170,$this->GetX());
        //Print the text
        $this->MultiCell($w,5,$data[$i],0,$a);
        //Put the position to the right of the cell
        $this->SetXY($x+$w,$y);
    }
	
	/*$this->SetDash(1,1);
	$this->Line(10,$this->GetY(),198,$this->GetY());
	$this->Ln(7);
	$this->Line(10,$this->GetY(),198,$this->GetY());
	
	$this->SetDash(0,0);*/
    //Go to the next line
	
    $this->Ln($h);
}

function Row1($data)
{
    //Calculate the height of the row
    $nb=0;
    for($i=0;$i<count($data);$i++)
        $nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
    $h=6*$nb;
    //Issue a page break first if needed
    $this->CheckPageBreak($h);
    //Draw the cells of the row
    for($i=0;$i<count($data);$i++)
    {
        $w=$this->widths[$i];
        $a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'C';
        //Save the current position
        $x=$this->GetX();
        $y=$this->GetY();
        //Draw the border
        $this->Rect($x,$y,$w,$h);
        //Print the text
        $this->MultiCell($w,8,$data[$i],0,$a);
        //Put the position to the right of the cell
        $this->SetXY($x+$w,$y);
    }
    //Go to the next line
    $this->Ln($h);
}
function Row2($data)
{
    //Calculate the height of the row
    $nb=0;
    for($i=0;$i<count($data);$i++)
        $nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
    $h=5*$nb;
    //Issue a page break first if needed
    $this->CheckPageBreak($h);
    //Draw the cells of the row
    for($i=0;$i<count($data);$i++)
    {
        $w=$this->widths[$i];
        $a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'C';
        //Save the current position
        $x=$this->GetX();
        $y=$this->GetY();
        //Draw the border
        $this->Rect($x,$y,$w,$h);
        //Print the text
        $this->MultiCell($w,5,$data[$i],0,$a);
        //Put the position to the right of the cell
        $this->SetXY($x+$w,$y);
    }
	
	
    //Go to the next line
    $this->Ln($h);
	/*if($i > 4 ){
			$this->AddPage();
	}*/
}

function CheckPageBreak($h)
{
    //If the height h would cause an overflow, add a new page immediately
    if($this->GetY()+$h>$this->PageBreakTrigger)
        $this->AddPage($this->CurOrientation);
}

function NbLines($w,$txt)
{
    //Computes the number of lines a MultiCell of width w will take
    $cw=&$this->CurrentFont['cw'];
    if($w==0)
        $w=$this->w-$this->rMargin-$this->x;
    $wmax=($w-2*$this->cMargin)*1000/$this->FontSize;
    $s=str_replace("\r",'',$txt);
    $nb=strlen($s);
    if($nb>0 and $s[$nb-1]=="\n")
        $nb--;
    $sep=-1;
    $i=0;
    $j=0;
    $l=0;
    $nl=1;
    while($i<$nb)
    {
        $c=$s[$i];
        if($c=="\n")
        {
            $i++;
            $sep=-1;
            $j=$i;
            $l=0;
            $nl++;
            continue;
        }
        if($c==' ')
            $sep=$i;
        $l+=$cw[$c];
        if($l>$wmax)
        {
            if($sep==-1)
            {
                if($i==$j)
                    $i++;
            }
            else
                $i=$sep+1;
            $sep=-1;
            $j=$i;
            $l=0;
            $nl++;
        }
        else
            $i++;
    }
    return $nl;
}

function Header()
{
    // Logo
    //$this->Image('images/logo5.png',10,6,30);

	
    // Arial bold 15
    //$this->SetFont('Arial','B',15);
    // Move to the right
    //$this->Cell(80);
    // Title
   // $this->Cell(30,10,'Title',1,0,'C');
    // Line break
    //$this->Ln(10);
	
	$this->SetFont('Arial','B',10);
	//$this->SetTextColor(234, 8, 8);
	//$this->Image('images/logo/imagen_group.jpg',85,5,30,0,'');
	//$this->Image('images/cotizacion_detalles_pago.jpg',150,43,50,0,'');
	//$this->Ln(10);
$this->Rect(10,5,259,18);
$this->Cell(260,7,utf8_decode('FICHA TÉCNICA'),0,0,'C');

$this->Ln(5);
$this->SetFont('Arial','',9);

$this->Cell(260,7,strtoupper(utf8_decode($GLOBALS['nombre']).' '.$GLOBALS['codigo']),0,0,'C');
$this->SetX(222);
//$this->Cell(40,7,utf8_decode('CERTIFICADO N° '.$GLOBALS['n_folio']),0,0,'L');



$this->Rect(10,30,259,50);


$this->Ln(15);
$this->SetFont('Arial','B',9);
$this->Cell(259,7,utf8_decode('Información Técnica'),'B',0,'C');
$this->Ln(8);



$this->SetFont('Arial','',7);
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','B',9);
$this->Cell(30,8,utf8_decode('Código Interno:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',9);
$this->Cell(95,8,utf8_decode($GLOBALS['codigo_interno']),'',0,'c');
$this->Ln(5);
$this->SetFont('Arial','',7);
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','B',9);
$this->Cell(30,8,utf8_decode('Principal:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',9);
$this->Cell(95,8,utf8_decode($GLOBALS['categoria']),'',0,'c');
$this->SetX(140);
$this->SetTextColor(0, 0, 0);
$this->Cell(20,8,utf8_decode(''),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(35,8,utf8_decode(''),'',0,'c');

$this->Ln(5);
$this->SetFont('Arial','',7);
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','B',9);
$this->Cell(30,8,utf8_decode('Categoría:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',9);
$this->Cell(95,8,utf8_decode($GLOBALS['marca']),'',0,'c');
$this->SetX(140);
$this->SetTextColor(0, 0, 0);
$this->Cell(20,8,utf8_decode(''),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(35,8,utf8_decode(''),'',0,'c');

$this->Ln(5);
$this->SetFont('Arial','',7);
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','B',9);
$this->Cell(30,8,utf8_decode('Ubicación:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',9);
$this->Cell(95,8,utf8_decode($GLOBALS['ubicacion']),'',0,'c');
$this->SetX(140);
$this->SetTextColor(0, 0, 0);
$this->Cell(20,8,utf8_decode(''),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(35,8,utf8_decode(''),'',0,'c');
$this->Ln(5);
$this->SetFont('Arial','',7);
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','B',9);
$this->Cell(30,8,utf8_decode('Estado:'),0,0,'0');
$this->SetFont('Arial','',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(95,8,utf8_decode($GLOBALS['estado1']),'',0,'c');
$this->Ln(5);
$this->SetFont('Arial','',7);
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','B',9);
$this->Cell(30,8,utf8_decode('Descripción:'),0,0,'0');
$this->SetFont('Arial','',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(95,8,utf8_decode($GLOBALS['descripcion1']),'',0,'c');
$this->Ln(5);
$this->SetFont('Arial','',7);
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','B',9);
$this->Cell(30,8,utf8_decode('Tipo:'),0,0,'0');
$this->SetFont('Arial','',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(95,8,utf8_decode($GLOBALS['fecha_inventario']),'',0,'c');
$this->Ln(5);
$this->SetFont('Arial','',7);
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','B',9);
//$this->Cell(30,8,utf8_decode('Registro de Baja:'),0,0,'0');
$this->SetFont('Arial','',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(95,8,utf8_decode($GLOBALS['registro_baja']),'',0,'c');
$this->Ln(7);
$this->SetFont('Arial','B',9);
$this->Cell(259,8,utf8_decode('Caracteristicas:'),'B',0,'C');
$this->Rect(10,80,259,130);






}

// Page footer
function Footer()
{
    $this->SetY(-120); 

    $maxWidth = 60;

    // Imagen 1
    if(!empty($GLOBALS['imagen_producto_1'])){
        $this->Image('../images/productos/'.$GLOBALS['imagen_producto_1'], 20, $this->GetY(), $maxWidth);
    }

    // Imagen 2
    if(!empty($GLOBALS['imagen_producto_2'])){
        $this->Image('../images/productos/'.$GLOBALS['imagen_producto_2'], 110, $this->GetY(), $maxWidth);
    }

    // Imagen 3
    if(!empty($GLOBALS['imagen_producto_3'])){
        $this->Image('../images/productos/'.$GLOBALS['imagen_producto_3'], 195, $this->GetY(), $maxWidth);
    }
}

}
?>